<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Code.ReportType StructType
 * Meta information extracted from the WSDL
 * - documentation: Dieser Typ gestattet die Kennzeichnung der Art eines zusätzlichen Reports. Es wird eine zu wählende Codeliste eingebunden, die mögliche Arten von Reports nennt (spezielles Format, innerhalb oder außerhalb von XTA definiert), die
 * in das XTA-Protokoll (TransportReport) eingefügt werden können.Die KoSIT gibt für den Standard XTA eine Codeliste heraus, welche Einträge für einschlägige Arten von Reports auflistet. Diese Codeliste kann auf Antrag erweitert bzw. geändert
 * werden. Sie ist durch XTA-konforme Systeme für übergreifende Prozesse zu verwenden.Diese Codeliste ist im XRepository (www.xrepository.de) unter Nennung ihrer Codelisten-URI urn:de:xta:codeliste:report.type auffindbar und kann dort im XML-Format
 * OASIS Genericode in der aktuellen Version abgerufen werden (ggf. sind auch frühere Versionen verfügbar). In die Attribute des vorliegenden Typs sind entsprechend ihre Codelisten-URI und die Nummer der ausgewählten Version einzutragen.Für lokale
 * Zwecke können XTA-Kommunikationspartner auch eigene Codelisten definieren (welche bilateral abgestimmte Reportformate benennen) und an dieser Stelle einbinden. In die Attribute des vorliegenden Typs werden dann Codelisten-URI und Versionsnummer der
 * selbstdefinierten Codeliste eingetragen.
 * @subpackage Structs
 */
class Code_ReportType extends AbstractStructBase
{
    /**
     * The listURI
     * Meta information extracted from the WSDL
     * - documentation: Hier wird die URI einer Codeliste eingetragen, die dadurch hier eingebunden ist. Es ist die Codeliste dafür auszuwählen, auf deren Basis der übermittelte Schlüssel durch den Leser der Nachricht interpretiert werden soll.
     * - use: required
     * @var string
     */
    public $listURI;
    /**
     * The listVersionID
     * Meta information extracted from the WSDL
     * - documentation: Die Version der Codeliste, welche der Interpretation des übermittelten Schlüssel zu Grunde gelegt werden soll.
     * - use: required
     * @var string
     */
    public $listVersionID;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - documentation: In diesem Element ist ein Schlüssel aus der referenzierten Codeliste einzutragen.
     * - form: unqualified
     * @var string
     */
    public $code;
    /**
     * Constructor method for Code.ReportType
     * @uses Code_ReportType::setListURI()
     * @uses Code_ReportType::setListVersionID()
     * @uses Code_ReportType::setCode()
     * @param string $listURI
     * @param string $listVersionID
     * @param string $code
     */
    public function __construct($listURI = null, $listVersionID = null, $code = null)
    {
        $this
            ->setListURI($listURI)
            ->setListVersionID($listVersionID)
            ->setCode($code);
    }
    /**
     * Get listURI value
     * @return string
     */
    public function getListURI()
    {
        return $this->listURI;
    }
    /**
     * Set listURI value
     * @param string $listURI
     * @return \StructType\Code_ReportType
     */
    public function setListURI($listURI = null)
    {
        // validation for constraint: string
        if (!is_null($listURI) && !is_string($listURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listURI, true), gettype($listURI)), __LINE__);
        }
        $this->listURI = $listURI;
        return $this;
    }
    /**
     * Get listVersionID value
     * @return string
     */
    public function getListVersionID()
    {
        return $this->listVersionID;
    }
    /**
     * Set listVersionID value
     * @param string $listVersionID
     * @return \StructType\Code_ReportType
     */
    public function setListVersionID($listVersionID = null)
    {
        // validation for constraint: string
        if (!is_null($listVersionID) && !is_string($listVersionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listVersionID, true), gettype($listVersionID)), __LINE__);
        }
        $this->listVersionID = $listVersionID;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\Code_ReportType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
}
