<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Code.RecordType StructType
 * Meta information extracted from the WSDL
 * - documentation: In diesen Typ ist eine auszuwählende bzw. selbst zu definierende Codeliste einzubinden, die Arten von Meldungen benennt, welche in das Protokoll zur Abarbeitung eines Transportauftrags (TransportReport) eingetragen werden. Dort
 * können die Meldungen als Fehler-, Warn- oder Informationseinträge eingeordnet sein.In die Attribute des vorliegenden Typs sind die Codelisten-URI und die Nummer der Version der ausgewählten Codeliste einzutragen.Die KoSIT hat die Absicht, für den
 * Standard XTA eine passende Codeliste zu definieren und als einheitliches Angebot zur Einbindung für diesen Typ bereitzustellen. Diese Codeliste ist, wenn die Bereitstellung erfolgt ist, im XRepository (www.xrepository.de) unter der Codelisten-URI
 * urn:de:xta:codeliste:record.type auffindbar und kann von dort im XML-Format OASIS Genericode abgerufen werden.
 * @subpackage Structs
 */
class Code_RecordType extends AbstractStructBase
{
    /**
     * The listURI
     * Meta information extracted from the WSDL
     * - documentation: Hier wird die URI einer Codeliste eingetragen, die dadurch hier eingebunden ist. Es ist die Codeliste dafür auszuwählen, auf deren Basis der übermittelte Schlüssel durch den Leser der Nachricht interpretiert werden soll.
     * - use: required
     * @var string
     */
    public $listURI;
    /**
     * The listVersionID
     * Meta information extracted from the WSDL
     * - documentation: Die Version der Codeliste, welche der Interpretation des übermittelten Schlüssels zu Grunde gelegt werden soll.
     * - use: required
     * @var string
     */
    public $listVersionID;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - documentation: In diesem Element ist ein Schlüssel aus der referenzierten Codeliste einzutragen.
     * - form: unqualified
     * @var string
     */
    public $code;
    /**
     * Constructor method for Code.RecordType
     * @uses Code_RecordType::setListURI()
     * @uses Code_RecordType::setListVersionID()
     * @uses Code_RecordType::setCode()
     * @param string $listURI
     * @param string $listVersionID
     * @param string $code
     */
    public function __construct($listURI = null, $listVersionID = null, $code = null)
    {
        $this
            ->setListURI($listURI)
            ->setListVersionID($listVersionID)
            ->setCode($code);
    }
    /**
     * Get listURI value
     * @return string
     */
    public function getListURI()
    {
        return $this->listURI;
    }
    /**
     * Set listURI value
     * @param string $listURI
     * @return \StructType\Code_RecordType
     */
    public function setListURI($listURI = null)
    {
        // validation for constraint: string
        if (!is_null($listURI) && !is_string($listURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listURI, true), gettype($listURI)), __LINE__);
        }
        $this->listURI = $listURI;
        return $this;
    }
    /**
     * Get listVersionID value
     * @return string
     */
    public function getListVersionID()
    {
        return $this->listVersionID;
    }
    /**
     * Set listVersionID value
     * @param string $listVersionID
     * @return \StructType\Code_RecordType
     */
    public function setListVersionID($listVersionID = null)
    {
        // validation for constraint: string
        if (!is_null($listVersionID) && !is_string($listVersionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listVersionID, true), gettype($listVersionID)), __LINE__);
        }
        $this->listVersionID = $listVersionID;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\Code_RecordType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
}
