<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AgreementMethodType StructType
 * Meta information extracted from the WSDL
 * - mixed: true
 * @subpackage Structs
 */
class AgreementMethodType extends AbstractStructBase
{
    /**
     * The Algorithm
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Algorithm;
    /**
     * The KA_Nonce
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $KA_Nonce;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The OriginatorKeyInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\KeyInfoType
     */
    public $OriginatorKeyInfo;
    /**
     * The RecipientKeyInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\KeyInfoType
     */
    public $RecipientKeyInfo;
    /**
     * Constructor method for AgreementMethodType
     * @uses AgreementMethodType::setAlgorithm()
     * @uses AgreementMethodType::setKA_Nonce()
     * @uses AgreementMethodType::setAny()
     * @uses AgreementMethodType::setOriginatorKeyInfo()
     * @uses AgreementMethodType::setRecipientKeyInfo()
     * @param string $algorithm
     * @param string $kA_Nonce
     * @param \DOMDocument $any
     * @param \StructType\KeyInfoType $originatorKeyInfo
     * @param \StructType\KeyInfoType $recipientKeyInfo
     */
    public function __construct($algorithm = null, $kA_Nonce = null, \DOMDocument $any = null, \StructType\KeyInfoType $originatorKeyInfo = null, \StructType\KeyInfoType $recipientKeyInfo = null)
    {
        $this
            ->setAlgorithm($algorithm)
            ->setKA_Nonce($kA_Nonce)
            ->setAny($any)
            ->setOriginatorKeyInfo($originatorKeyInfo)
            ->setRecipientKeyInfo($recipientKeyInfo);
    }
    /**
     * Get Algorithm value
     * @return string
     */
    public function getAlgorithm()
    {
        return $this->Algorithm;
    }
    /**
     * Set Algorithm value
     * @param string $algorithm
     * @return \StructType\AgreementMethodType
     */
    public function setAlgorithm($algorithm = null)
    {
        // validation for constraint: string
        if (!is_null($algorithm) && !is_string($algorithm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($algorithm, true), gettype($algorithm)), __LINE__);
        }
        $this->Algorithm = $algorithm;
        return $this;
    }
    /**
     * Get KA_Nonce value
     * @return string|null
     */
    public function getKA_Nonce()
    {
        return $this->{'KA-Nonce'};
    }
    /**
     * Set KA_Nonce value
     * @param string $kA_Nonce
     * @return \StructType\AgreementMethodType
     */
    public function setKA_Nonce($kA_Nonce = null)
    {
        // validation for constraint: string
        if (!is_null($kA_Nonce) && !is_string($kA_Nonce)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kA_Nonce, true), gettype($kA_Nonce)), __LINE__);
        }
        $this->KA_Nonce = $this->{'KA-Nonce'} = $kA_Nonce;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\AgreementMethodType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get OriginatorKeyInfo value
     * @return \StructType\KeyInfoType|null
     */
    public function getOriginatorKeyInfo()
    {
        return $this->OriginatorKeyInfo;
    }
    /**
     * Set OriginatorKeyInfo value
     * @param \StructType\KeyInfoType $originatorKeyInfo
     * @return \StructType\AgreementMethodType
     */
    public function setOriginatorKeyInfo(\StructType\KeyInfoType $originatorKeyInfo = null)
    {
        $this->OriginatorKeyInfo = $originatorKeyInfo;
        return $this;
    }
    /**
     * Get RecipientKeyInfo value
     * @return \StructType\KeyInfoType|null
     */
    public function getRecipientKeyInfo()
    {
        return $this->RecipientKeyInfo;
    }
    /**
     * Set RecipientKeyInfo value
     * @param \StructType\KeyInfoType $recipientKeyInfo
     * @return \StructType\AgreementMethodType
     */
    public function setRecipientKeyInfo(\StructType\KeyInfoType $recipientKeyInfo = null)
    {
        $this->RecipientKeyInfo = $recipientKeyInfo;
        return $this;
    }
}
