<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalReportListType StructType
 * Meta information extracted from the WSDL
 * - documentation: Dieser Typ gestattet das Ablegen weiterer Prüfberichte, welche das XTA-Protokoll (TransportReport) ergänzen sollen.
 * @subpackage Structs
 */
class AdditionalReportListType extends AbstractStructBase
{
    /**
     * The Report
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Report[]
     */
    public $Report;
    /**
     * Constructor method for AdditionalReportListType
     * @uses AdditionalReportListType::setReport()
     * @param \StructType\Report[] $report
     */
    public function __construct(array $report = array())
    {
        $this
            ->setReport($report);
    }
    /**
     * Get Report value
     * @return \StructType\Report[]|null
     */
    public function getReport()
    {
        return $this->Report;
    }
    /**
     * This method is responsible for validating the values passed to the setReport method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReport method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReportForArrayConstraintsFromSetReport(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $additionalReportListTypeReportItem) {
            // validation for constraint: itemType
            if (!$additionalReportListTypeReportItem instanceof \StructType\Report) {
                $invalidValues[] = is_object($additionalReportListTypeReportItem) ? get_class($additionalReportListTypeReportItem) : sprintf('%s(%s)', gettype($additionalReportListTypeReportItem), var_export($additionalReportListTypeReportItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Report property can only contain items of type \StructType\Report, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Report value
     * @throws \InvalidArgumentException
     * @param \StructType\Report[] $report
     * @return \StructType\AdditionalReportListType
     */
    public function setReport(array $report = array())
    {
        // validation for constraint: array
        if ('' !== ($reportArrayErrorMessage = self::validateReportForArrayConstraintsFromSetReport($report))) {
            throw new \InvalidArgumentException($reportArrayErrorMessage, __LINE__);
        }
        $this->Report = $report;
        return $this;
    }
    /**
     * Add item to Report value
     * @throws \InvalidArgumentException
     * @param \StructType\Report $item
     * @return \StructType\AdditionalReportListType
     */
    public function addToReport(\StructType\Report $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Report) {
            throw new \InvalidArgumentException(sprintf('The Report property can only contain items of type \StructType\Report, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Report[] = $item;
        return $this;
    }
}
