<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcceptedMsgLimits StructType
 * @subpackage Structs
 */
class AcceptedMsgLimits extends AbstractStructBase
{
    /**
     * The MaxSize
     * @var int
     */
    public $MaxSize;
    /**
     * The MaxPerHour
     * @var int
     */
    public $MaxPerHour;
    /**
     * Constructor method for AcceptedMsgLimits
     * @uses AcceptedMsgLimits::setMaxSize()
     * @uses AcceptedMsgLimits::setMaxPerHour()
     * @param int $maxSize
     * @param int $maxPerHour
     */
    public function __construct($maxSize = null, $maxPerHour = null)
    {
        $this
            ->setMaxSize($maxSize)
            ->setMaxPerHour($maxPerHour);
    }
    /**
     * Get MaxSize value
     * @return int|null
     */
    public function getMaxSize()
    {
        return $this->MaxSize;
    }
    /**
     * Set MaxSize value
     * @param int $maxSize
     * @return \StructType\AcceptedMsgLimits
     */
    public function setMaxSize($maxSize = null)
    {
        // validation for constraint: int
        if (!is_null($maxSize) && !(is_int($maxSize) || ctype_digit($maxSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSize, true), gettype($maxSize)), __LINE__);
        }
        $this->MaxSize = $maxSize;
        return $this;
    }
    /**
     * Get MaxPerHour value
     * @return int|null
     */
    public function getMaxPerHour()
    {
        return $this->MaxPerHour;
    }
    /**
     * Set MaxPerHour value
     * @param int $maxPerHour
     * @return \StructType\AcceptedMsgLimits
     */
    public function setMaxPerHour($maxPerHour = null)
    {
        // validation for constraint: int
        if (!is_null($maxPerHour) && !(is_int($maxPerHour) || ctype_digit($maxPerHour))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxPerHour, true), gettype($maxPerHour)), __LINE__);
        }
        $this->MaxPerHour = $maxPerHour;
        return $this;
    }
}
