<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SecurityToken StructType
 * @subpackage Structs
 */
class SecurityToken extends AbstractStructBase
{
    /**
     * The usage
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $usage;
    /**
     * The BinarySecurityToken
     * Meta information extracted from the WSDL
     * - choice: BinarySecurityToken | SecurityTokenReference | UsernameToken
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - ref: wsse:BinarySecurityToken
     * @var \StructType\BinarySecurityTokenType
     */
    public $BinarySecurityToken;
    /**
     * The SecurityTokenReference
     * Meta information extracted from the WSDL
     * - choice: BinarySecurityToken | SecurityTokenReference | UsernameToken
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - ref: wsse:SecurityTokenReference
     * @var \StructType\SecurityTokenReferenceType
     */
    public $SecurityTokenReference;
    /**
     * The UsernameToken
     * Meta information extracted from the WSDL
     * - choice: BinarySecurityToken | SecurityTokenReference | UsernameToken
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - ref: wsse:UsernameToken
     * @var \StructType\UsernameTokenType
     */
    public $UsernameToken;
    /**
     * The payloadRef
     * @var string
     */
    public $payloadRef;
    /**
     * Constructor method for SecurityToken
     * @uses SecurityToken::setUsage()
     * @uses SecurityToken::setBinarySecurityToken()
     * @uses SecurityToken::setSecurityTokenReference()
     * @uses SecurityToken::setUsernameToken()
     * @uses SecurityToken::setPayloadRef()
     * @param string $usage
     * @param \StructType\BinarySecurityTokenType $binarySecurityToken
     * @param \StructType\SecurityTokenReferenceType $securityTokenReference
     * @param \StructType\UsernameTokenType $usernameToken
     * @param string $payloadRef
     */
    public function __construct($usage = null, \StructType\BinarySecurityTokenType $binarySecurityToken = null, \StructType\SecurityTokenReferenceType $securityTokenReference = null, \StructType\UsernameTokenType $usernameToken = null, $payloadRef = null)
    {
        $this
            ->setUsage($usage)
            ->setBinarySecurityToken($binarySecurityToken)
            ->setSecurityTokenReference($securityTokenReference)
            ->setUsernameToken($usernameToken)
            ->setPayloadRef($payloadRef);
    }
    /**
     * Get usage value
     * @return string
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @param string $usage
     * @return \StructType\SecurityToken
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: string
        if (!is_null($usage) && !is_string($usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usage, true), gettype($usage)), __LINE__);
        }
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get BinarySecurityToken value
     * @return \StructType\BinarySecurityTokenType|null
     */
    public function getBinarySecurityToken()
    {
        return isset($this->BinarySecurityToken) ? $this->BinarySecurityToken : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBinarySecurityToken method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBinarySecurityToken method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBinarySecurityTokenForChoiceConstraintsFromSetBinarySecurityToken($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'SecurityTokenReference',
            'UsernameToken',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property BinarySecurityToken can\'t be set as the property %s is already set. Only one property must be set among these properties: BinarySecurityToken, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set BinarySecurityToken value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BinarySecurityTokenType $binarySecurityToken
     * @return \StructType\SecurityToken
     */
    public function setBinarySecurityToken(\StructType\BinarySecurityTokenType $binarySecurityToken = null)
    {
        // validation for constraint: choice(BinarySecurityToken, SecurityTokenReference, UsernameToken)
        if ('' !== ($binarySecurityTokenChoiceErrorMessage = self::validateBinarySecurityTokenForChoiceConstraintsFromSetBinarySecurityToken($binarySecurityToken))) {
            throw new \InvalidArgumentException($binarySecurityTokenChoiceErrorMessage, __LINE__);
        }
        if (is_null($binarySecurityToken) || (is_array($binarySecurityToken) && empty($binarySecurityToken))) {
            unset($this->BinarySecurityToken);
        } else {
            $this->BinarySecurityToken = $binarySecurityToken;
        }
        return $this;
    }
    /**
     * Get SecurityTokenReference value
     * @return \StructType\SecurityTokenReferenceType|null
     */
    public function getSecurityTokenReference()
    {
        return isset($this->SecurityTokenReference) ? $this->SecurityTokenReference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSecurityTokenReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSecurityTokenReference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSecurityTokenReferenceForChoiceConstraintsFromSetSecurityTokenReference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BinarySecurityToken',
            'UsernameToken',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SecurityTokenReference can\'t be set as the property %s is already set. Only one property must be set among these properties: SecurityTokenReference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SecurityTokenReference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SecurityTokenReferenceType $securityTokenReference
     * @return \StructType\SecurityToken
     */
    public function setSecurityTokenReference(\StructType\SecurityTokenReferenceType $securityTokenReference = null)
    {
        // validation for constraint: choice(BinarySecurityToken, SecurityTokenReference, UsernameToken)
        if ('' !== ($securityTokenReferenceChoiceErrorMessage = self::validateSecurityTokenReferenceForChoiceConstraintsFromSetSecurityTokenReference($securityTokenReference))) {
            throw new \InvalidArgumentException($securityTokenReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($securityTokenReference) || (is_array($securityTokenReference) && empty($securityTokenReference))) {
            unset($this->SecurityTokenReference);
        } else {
            $this->SecurityTokenReference = $securityTokenReference;
        }
        return $this;
    }
    /**
     * Get UsernameToken value
     * @return \StructType\UsernameTokenType|null
     */
    public function getUsernameToken()
    {
        return isset($this->UsernameToken) ? $this->UsernameToken : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUsernameToken method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUsernameToken method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUsernameTokenForChoiceConstraintsFromSetUsernameToken($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'BinarySecurityToken',
            'SecurityTokenReference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property UsernameToken can\'t be set as the property %s is already set. Only one property must be set among these properties: UsernameToken, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set UsernameToken value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UsernameTokenType $usernameToken
     * @return \StructType\SecurityToken
     */
    public function setUsernameToken(\StructType\UsernameTokenType $usernameToken = null)
    {
        // validation for constraint: choice(BinarySecurityToken, SecurityTokenReference, UsernameToken)
        if ('' !== ($usernameTokenChoiceErrorMessage = self::validateUsernameTokenForChoiceConstraintsFromSetUsernameToken($usernameToken))) {
            throw new \InvalidArgumentException($usernameTokenChoiceErrorMessage, __LINE__);
        }
        if (is_null($usernameToken) || (is_array($usernameToken) && empty($usernameToken))) {
            unset($this->UsernameToken);
        } else {
            $this->UsernameToken = $usernameToken;
        }
        return $this;
    }
    /**
     * Get payloadRef value
     * @return string|null
     */
    public function getPayloadRef()
    {
        return $this->payloadRef;
    }
    /**
     * Set payloadRef value
     * @param string $payloadRef
     * @return \StructType\SecurityToken
     */
    public function setPayloadRef($payloadRef = null)
    {
        // validation for constraint: string
        if (!is_null($payloadRef) && !is_string($payloadRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payloadRef, true), gettype($payloadRef)), __LINE__);
        }
        $this->payloadRef = $payloadRef;
        return $this;
    }
}
