<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatesToType StructType
 * Meta information extracted from the WSDL
 * - mixed: false
 * @subpackage Structs
 */
class RelatesToType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The RelationshipType
     * Meta information extracted from the WSDL
     * - default: http://www.w3.org/2005/08/addressing/reply
     * - union: RelationshipType | anyURI
     * - use: optional
     * @var string
     */
    public $RelationshipType;
    /**
     * Constructor method for RelatesToType
     * @uses RelatesToType::set_()
     * @uses RelatesToType::setRelationshipType()
     * @param string $_
     * @param string $relationshipType
     */
    public function __construct($_ = null, $relationshipType = 'http://www.w3.org/2005/08/addressing/reply')
    {
        $this
            ->set_($_)
            ->setRelationshipType($relationshipType);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\RelatesToType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get RelationshipType value
     * @return string|null
     */
    public function getRelationshipType()
    {
        return $this->RelationshipType;
    }
    /**
     * This method is responsible for validating the value passed to the setRelationshipType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelationshipType method
     * This is a set of validation rules based on the union types associated to the property being set by the setRelationshipType method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelationshipTypeForUnionConstraintsFromSetRelationshipType($value)
    {
        $message = '';
        // validation for constraint: enumeration
        if (!\EnumType\RelationshipType::valueIsValid($value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RelationshipType', is_array($value) ? implode(', ', $value) : var_export($value, true), implode(', ', \EnumType\RelationshipType::getValidValues())), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: RelationshipType, anyURI. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set RelationshipType value
     * @param string $relationshipType
     * @return \StructType\RelatesToType
     */
    public function setRelationshipType($relationshipType = 'http://www.w3.org/2005/08/addressing/reply')
    {
        // validation for constraint: string
        if (!is_null($relationshipType) && !is_string($relationshipType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipType, true), gettype($relationshipType)), __LINE__);
        }
        // validation for constraint: union(RelationshipType, anyURI)
        if ('' !== ($relationshipTypeUnionErrorMessage = self::validateRelationshipTypeForUnionConstraintsFromSetRelationshipType($relationshipType))) {
            throw new \InvalidArgumentException($relationshipTypeUnionErrorMessage, __LINE__);
        }
        $this->RelationshipType = $relationshipType;
        return $this;
    }
}
