<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceType StructType
 * Meta information extracted from the WSDL
 * - documentation: This type represents a reference to an external security token.
 * @subpackage Structs
 */
class ReferenceType extends AbstractStructBase
{
    /**
     * The Transforms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:Transforms
     * @var \StructType\TransformsType
     */
    public $Transforms;
    /**
     * The DigestMethod
     * Meta information extracted from the WSDL
     * - ref: ds:DigestMethod
     * @var \StructType\DigestMethodType
     */
    public $DigestMethod;
    /**
     * The DigestValue
     * Meta information extracted from the WSDL
     * - base: base64Binary
     * - ref: ds:DigestValue
     * @var string
     */
    public $DigestValue;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * The URI
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $URI;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The ValueType
     * @var string
     */
    public $ValueType;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for ReferenceType
     * @uses ReferenceType::setTransforms()
     * @uses ReferenceType::setDigestMethod()
     * @uses ReferenceType::setDigestValue()
     * @uses ReferenceType::setId()
     * @uses ReferenceType::setURI()
     * @uses ReferenceType::setType()
     * @uses ReferenceType::setValueType()
     * @uses ReferenceType::setAny()
     * @param \StructType\TransformsType $transforms
     * @param \StructType\DigestMethodType $digestMethod
     * @param string $digestValue
     * @param string $id
     * @param string $uRI
     * @param string $type
     * @param string $valueType
     * @param \DOMDocument $any
     */
    public function __construct(\StructType\TransformsType $transforms = null, \StructType\DigestMethodType $digestMethod = null, $digestValue = null, $id = null, $uRI = null, $type = null, $valueType = null, \DOMDocument $any = null)
    {
        $this
            ->setTransforms($transforms)
            ->setDigestMethod($digestMethod)
            ->setDigestValue($digestValue)
            ->setId($id)
            ->setURI($uRI)
            ->setType($type)
            ->setValueType($valueType)
            ->setAny($any);
    }
    /**
     * Get Transforms value
     * @return \StructType\TransformsType|null
     */
    public function getTransforms()
    {
        return $this->Transforms;
    }
    /**
     * Set Transforms value
     * @param \StructType\TransformsType $transforms
     * @return \StructType\ReferenceType
     */
    public function setTransforms(\StructType\TransformsType $transforms = null)
    {
        $this->Transforms = $transforms;
        return $this;
    }
    /**
     * Get DigestMethod value
     * @return \StructType\DigestMethodType|null
     */
    public function getDigestMethod()
    {
        return $this->DigestMethod;
    }
    /**
     * Set DigestMethod value
     * @param \StructType\DigestMethodType $digestMethod
     * @return \StructType\ReferenceType
     */
    public function setDigestMethod(\StructType\DigestMethodType $digestMethod = null)
    {
        $this->DigestMethod = $digestMethod;
        return $this;
    }
    /**
     * Get DigestValue value
     * @return string|null
     */
    public function getDigestValue()
    {
        return $this->DigestValue;
    }
    /**
     * Set DigestValue value
     * @param string $digestValue
     * @return \StructType\ReferenceType
     */
    public function setDigestValue($digestValue = null)
    {
        // validation for constraint: string
        if (!is_null($digestValue) && !is_string($digestValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($digestValue, true), gettype($digestValue)), __LINE__);
        }
        $this->DigestValue = $digestValue;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\ReferenceType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get URI value
     * @return string|null
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param string $uRI
     * @return \StructType\ReferenceType
     */
    public function setURI($uRI = null)
    {
        // validation for constraint: string
        if (!is_null($uRI) && !is_string($uRI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRI, true), gettype($uRI)), __LINE__);
        }
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\ReferenceType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ValueType value
     * @return string|null
     */
    public function getValueType()
    {
        return $this->ValueType;
    }
    /**
     * Set ValueType value
     * @param string $valueType
     * @return \StructType\ReferenceType
     */
    public function setValueType($valueType = null)
    {
        // validation for constraint: string
        if (!is_null($valueType) && !is_string($valueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueType, true), gettype($valueType)), __LINE__);
        }
        $this->ValueType = $valueType;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\ReferenceType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
