<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecordType StructType
 * Meta information extracted from the WSDL
 * - documentation: Der Typ zur Kennzeichnung und Erläuterung einer Meldung (anwendbar auf Info-, Fehlermeldungen und Warnungen).
 * @subpackage Structs
 */
class RecordType extends AbstractStructBase
{
    /**
     * The Timestamp
     * Meta information extracted from the WSDL
     * - documentation: Zeitstempel für den Zeitpunkt der Aufzeichnung der Meldung.
     * @var string
     */
    public $Timestamp;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Schlüssel, der die Bedeutung der Meldung kodiert. Dieser Schlüssel muss aus einer eingebundenen Codeliste stammen.
     * @var \StructType\Code_RecordType
     */
    public $Code;
    /**
     * The Reason
     * Meta information extracted from the WSDL
     * - documentation: Hier wird zur weiteren Erläuterung der Grund der Meldung als Freitext eingetragen.
     * @var string
     */
    public $Reason;
    /**
     * Constructor method for RecordType
     * @uses RecordType::setTimestamp()
     * @uses RecordType::setCode()
     * @uses RecordType::setReason()
     * @param string $timestamp
     * @param \StructType\Code_RecordType $code
     * @param string $reason
     */
    public function __construct($timestamp = null, \StructType\Code_RecordType $code = null, $reason = null)
    {
        $this
            ->setTimestamp($timestamp)
            ->setCode($code)
            ->setReason($reason);
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \StructType\RecordType
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get Code value
     * @return \StructType\Code_RecordType|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param \StructType\Code_RecordType $code
     * @return \StructType\RecordType
     */
    public function setCode(\StructType\Code_RecordType $code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \StructType\RecordType
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
}
