<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReceiptDemandType StructType
 * @subpackage Structs
 */
class ReceiptDemandType extends AbstractStructBase
{
    /**
     * The ReplyTo
     * Meta information extracted from the WSDL
     * - ref: wsa:ReplyTo
     * @var \StructType\EndpointReferenceType
     */
    public $ReplyTo;
    /**
     * The qualTSPForReceipt
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $qualTSPForReceipt;
    /**
     * The echoRequest
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $echoRequest;
    /**
     * Constructor method for ReceiptDemandType
     * @uses ReceiptDemandType::setReplyTo()
     * @uses ReceiptDemandType::setQualTSPForReceipt()
     * @uses ReceiptDemandType::setEchoRequest()
     * @param \StructType\EndpointReferenceType $replyTo
     * @param bool $qualTSPForReceipt
     * @param bool $echoRequest
     */
    public function __construct(\StructType\EndpointReferenceType $replyTo = null, $qualTSPForReceipt = false, $echoRequest = false)
    {
        $this
            ->setReplyTo($replyTo)
            ->setQualTSPForReceipt($qualTSPForReceipt)
            ->setEchoRequest($echoRequest);
    }
    /**
     * Get ReplyTo value
     * @return \StructType\EndpointReferenceType|null
     */
    public function getReplyTo()
    {
        return $this->ReplyTo;
    }
    /**
     * Set ReplyTo value
     * @param \StructType\EndpointReferenceType $replyTo
     * @return \StructType\ReceiptDemandType
     */
    public function setReplyTo(\StructType\EndpointReferenceType $replyTo = null)
    {
        $this->ReplyTo = $replyTo;
        return $this;
    }
    /**
     * Get qualTSPForReceipt value
     * @return bool|null
     */
    public function getQualTSPForReceipt()
    {
        return $this->qualTSPForReceipt;
    }
    /**
     * Set qualTSPForReceipt value
     * @param bool $qualTSPForReceipt
     * @return \StructType\ReceiptDemandType
     */
    public function setQualTSPForReceipt($qualTSPForReceipt = false)
    {
        // validation for constraint: boolean
        if (!is_null($qualTSPForReceipt) && !is_bool($qualTSPForReceipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($qualTSPForReceipt, true), gettype($qualTSPForReceipt)), __LINE__);
        }
        $this->qualTSPForReceipt = $qualTSPForReceipt;
        return $this;
    }
    /**
     * Get echoRequest value
     * @return bool|null
     */
    public function getEchoRequest()
    {
        return $this->echoRequest;
    }
    /**
     * Set echoRequest value
     * @param bool $echoRequest
     * @return \StructType\ReceiptDemandType
     */
    public function setEchoRequest($echoRequest = false)
    {
        // validation for constraint: boolean
        if (!is_null($echoRequest) && !is_bool($echoRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($echoRequest, true), gettype($echoRequest)), __LINE__);
        }
        $this->echoRequest = $echoRequest;
        return $this;
    }
}
