<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessRef StructType
 * Meta information extracted from the WSDL
 * - documentation: References to business process-id's (like ebMS Conversation-Id, "Aktenzeichen" in Germany)
 * @subpackage Structs
 */
class ProcessRef extends AbstractStructBase
{
    /**
     * The Requester
     * Meta information extracted from the WSDL
     * - documentation: Ref on requester (Source Application) side
     * - minOccurs: 0
     * @var \StructType\ProcessIdentifierType
     */
    public $Requester;
    /**
     * The Responder
     * Meta information extracted from the WSDL
     * - documentation: Ref on responder (Target Application) side, if different
     * - minOccurs: 0
     * @var \StructType\ProcessIdentifierType
     */
    public $Responder;
    /**
     * Constructor method for ProcessRef
     * @uses ProcessRef::setRequester()
     * @uses ProcessRef::setResponder()
     * @param \StructType\ProcessIdentifierType $requester
     * @param \StructType\ProcessIdentifierType $responder
     */
    public function __construct(\StructType\ProcessIdentifierType $requester = null, \StructType\ProcessIdentifierType $responder = null)
    {
        $this
            ->setRequester($requester)
            ->setResponder($responder);
    }
    /**
     * Get Requester value
     * @return \StructType\ProcessIdentifierType|null
     */
    public function getRequester()
    {
        return $this->Requester;
    }
    /**
     * Set Requester value
     * @param \StructType\ProcessIdentifierType $requester
     * @return \StructType\ProcessRef
     */
    public function setRequester(\StructType\ProcessIdentifierType $requester = null)
    {
        $this->Requester = $requester;
        return $this;
    }
    /**
     * Get Responder value
     * @return \StructType\ProcessIdentifierType|null
     */
    public function getResponder()
    {
        return $this->Responder;
    }
    /**
     * Set Responder value
     * @param \StructType\ProcessIdentifierType $responder
     * @return \StructType\ProcessRef
     */
    public function setResponder(\StructType\ProcessIdentifierType $responder = null)
    {
        $this->Responder = $responder;
        return $this;
    }
}
