<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessIdentifierType StructType
 * Meta information extracted from the WSDL
 * - documentation: Process ID message is realated to
 * - base: xs:string
 * - minLength: 1
 * @subpackage Structs
 */
class ProcessIdentifierType extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minLength: 1
     * @var string
     */
    public $_;
    /**
     * The ProccesName
     * Meta information extracted from the WSDL
     * - documentation: Process may have a name, e.g. "order"
     * - base: xs:string
     * - minLength: 1
     * @var string
     */
    public $ProccesName;
    /**
     * Constructor method for ProcessIdentifierType
     * @uses ProcessIdentifierType::set_()
     * @uses ProcessIdentifierType::setProccesName()
     * @param string $_
     * @param string $proccesName
     */
    public function __construct($_ = null, $proccesName = null)
    {
        $this
            ->set_($_)
            ->setProccesName($proccesName);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\ProcessIdentifierType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($_) && mb_strlen($_) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get ProccesName value
     * @return string|null
     */
    public function getProccesName()
    {
        return $this->ProccesName;
    }
    /**
     * Set ProccesName value
     * @param string $proccesName
     * @return \StructType\ProcessIdentifierType
     */
    public function setProccesName($proccesName = null)
    {
        // validation for constraint: string
        if (!is_null($proccesName) && !is_string($proccesName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proccesName, true), gettype($proccesName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($proccesName) && mb_strlen($proccesName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($proccesName)), __LINE__);
        }
        $this->ProccesName = $proccesName;
        return $this;
    }
}
