<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProblemActionType StructType
 * Meta information extracted from the WSDL
 * - mixed: false
 * @subpackage Structs
 */
class ProblemActionType extends AbstractStructBase
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:Action
     * @var \StructType\AttributedURIType
     */
    public $Action;
    /**
     * The SoapAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SoapAction;
    /**
     * Constructor method for ProblemActionType
     * @uses ProblemActionType::setAction()
     * @uses ProblemActionType::setSoapAction()
     * @param \StructType\AttributedURIType $action
     * @param string $soapAction
     */
    public function __construct(\StructType\AttributedURIType $action = null, $soapAction = null)
    {
        $this
            ->setAction($action)
            ->setSoapAction($soapAction);
    }
    /**
     * Get Action value
     * @return \StructType\AttributedURIType|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @param \StructType\AttributedURIType $action
     * @return \StructType\ProblemActionType
     */
    public function setAction(\StructType\AttributedURIType $action = null)
    {
        $this->Action = $action;
        return $this;
    }
    /**
     * Get SoapAction value
     * @return string|null
     */
    public function getSoapAction()
    {
        return $this->SoapAction;
    }
    /**
     * Set SoapAction value
     * @param string $soapAction
     * @return \StructType\ProblemActionType
     */
    public function setSoapAction($soapAction = null)
    {
        // validation for constraint: string
        if (!is_null($soapAction) && !is_string($soapAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($soapAction, true), gettype($soapAction)), __LINE__);
        }
        $this->SoapAction = $soapAction;
        return $this;
    }
}
