<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyAttachment StructType
 * @subpackage Structs
 */
class PolicyAttachment extends AbstractStructBase
{
    /**
     * The AppliesTo
     * Meta information extracted from the WSDL
     * - ref: tns:AppliesTo
     * @var \StructType\AppliesTo
     */
    public $AppliesTo;
    /**
     * The Policy
     * Meta information extracted from the WSDL
     * - choice: Policy | PolicyReference
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * - ref: tns:Policy
     * @var \StructType\Policy
     */
    public $Policy;
    /**
     * The PolicyReference
     * Meta information extracted from the WSDL
     * - choice: Policy | PolicyReference
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 1
     * - ref: tns:PolicyReference
     * @var \StructType\PolicyReference
     */
    public $PolicyReference;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for PolicyAttachment
     * @uses PolicyAttachment::setAppliesTo()
     * @uses PolicyAttachment::setPolicy()
     * @uses PolicyAttachment::setPolicyReference()
     * @uses PolicyAttachment::setAny()
     * @param \StructType\AppliesTo $appliesTo
     * @param \StructType\Policy $policy
     * @param \StructType\PolicyReference $policyReference
     * @param \DOMDocument $any
     */
    public function __construct(\StructType\AppliesTo $appliesTo = null, \StructType\Policy $policy = null, \StructType\PolicyReference $policyReference = null, \DOMDocument $any = null)
    {
        $this
            ->setAppliesTo($appliesTo)
            ->setPolicy($policy)
            ->setPolicyReference($policyReference)
            ->setAny($any);
    }
    /**
     * Get AppliesTo value
     * @return \StructType\AppliesTo|null
     */
    public function getAppliesTo()
    {
        return $this->AppliesTo;
    }
    /**
     * Set AppliesTo value
     * @param \StructType\AppliesTo $appliesTo
     * @return \StructType\PolicyAttachment
     */
    public function setAppliesTo(\StructType\AppliesTo $appliesTo = null)
    {
        $this->AppliesTo = $appliesTo;
        return $this;
    }
    /**
     * Get Policy value
     * @return \StructType\Policy|null
     */
    public function getPolicy()
    {
        return isset($this->Policy) ? $this->Policy : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicy method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePolicyForChoiceConstraintsFromSetPolicy($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PolicyReference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Policy can\'t be set as the property %s is already set. Only one property must be set among these properties: Policy, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Policy value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Policy $policy
     * @return \StructType\PolicyAttachment
     */
    public function setPolicy(\StructType\Policy $policy = null)
    {
        // validation for constraint: choice(Policy, PolicyReference)
        if ('' !== ($policyChoiceErrorMessage = self::validatePolicyForChoiceConstraintsFromSetPolicy($policy))) {
            throw new \InvalidArgumentException($policyChoiceErrorMessage, __LINE__);
        }
        if (is_null($policy) || (is_array($policy) && empty($policy))) {
            unset($this->Policy);
        } else {
            $this->Policy = $policy;
        }
        return $this;
    }
    /**
     * Get PolicyReference value
     * @return \StructType\PolicyReference|null
     */
    public function getPolicyReference()
    {
        return isset($this->PolicyReference) ? $this->PolicyReference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPolicyReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicyReference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePolicyReferenceForChoiceConstraintsFromSetPolicyReference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Policy',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PolicyReference can\'t be set as the property %s is already set. Only one property must be set among these properties: PolicyReference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PolicyReference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PolicyReference $policyReference
     * @return \StructType\PolicyAttachment
     */
    public function setPolicyReference(\StructType\PolicyReference $policyReference = null)
    {
        // validation for constraint: choice(Policy, PolicyReference)
        if ('' !== ($policyReferenceChoiceErrorMessage = self::validatePolicyReferenceForChoiceConstraintsFromSetPolicyReference($policyReference))) {
            throw new \InvalidArgumentException($policyReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($policyReference) || (is_array($policyReference) && empty($policyReference))) {
            unset($this->PolicyReference);
        } else {
            $this->PolicyReference = $policyReference;
        }
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\PolicyAttachment
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
