<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartyIdentifierType StructType
 * Meta information extracted from the WSDL
 * - documentation: Value of generic party identifier, as classified by @type attribute, e.g.: Prefix:Kennung
 * @subpackage Structs
 */
class PartyIdentifierType extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - documentation: Orientation: ebMS Core: type, how to interpret Party-Id value, e.g.: xöv oder Justiz
     * - base: xs:string
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $type;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: optional "friendly name" value for displaying in user agents (as e.g. known from eMail)
     * - base: xs:string
     * - minLength: 1
     * @var string
     */
    public $name;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - documentation: Concrete role of party in business scenario (e.g. "buyer", "Meldehörde", "Standesamt"...)
     * - base: xs:string
     * - minLength: 1
     * @var string
     */
    public $category;
    /**
     * Constructor method for PartyIdentifierType
     * @uses PartyIdentifierType::setType()
     * @uses PartyIdentifierType::set_()
     * @uses PartyIdentifierType::setName()
     * @uses PartyIdentifierType::setCategory()
     * @param string $type
     * @param string $_
     * @param string $name
     * @param string $category
     */
    public function __construct($type = null, $_ = null, $name = null, $category = null)
    {
        $this
            ->setType($type)
            ->set_($_)
            ->setName($name)
            ->setCategory($category);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\PartyIdentifierType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($type) && mb_strlen($type) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\PartyIdentifierType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\PartyIdentifierType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name) && mb_strlen($name) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\PartyIdentifierType
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($category) && mb_strlen($category) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
}
