<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObsoleteAfterAssertion StructType
 * @subpackage Structs
 */
class ObsoleteAfterAssertion extends AbstractStructBase
{
    /**
     * The MsgRetainDays
     * @var int
     */
    public $MsgRetainDays;
    /**
     * The WarningBeforeMsgObsolete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $WarningBeforeMsgObsolete;
    /**
     * The PolicyRef
     * @var string
     */
    public $PolicyRef;
    /**
     * Constructor method for ObsoleteAfterAssertion
     * @uses ObsoleteAfterAssertion::setMsgRetainDays()
     * @uses ObsoleteAfterAssertion::setWarningBeforeMsgObsolete()
     * @uses ObsoleteAfterAssertion::setPolicyRef()
     * @param int $msgRetainDays
     * @param int $warningBeforeMsgObsolete
     * @param string $policyRef
     */
    public function __construct($msgRetainDays = null, $warningBeforeMsgObsolete = null, $policyRef = null)
    {
        $this
            ->setMsgRetainDays($msgRetainDays)
            ->setWarningBeforeMsgObsolete($warningBeforeMsgObsolete)
            ->setPolicyRef($policyRef);
    }
    /**
     * Get MsgRetainDays value
     * @return int|null
     */
    public function getMsgRetainDays()
    {
        return $this->MsgRetainDays;
    }
    /**
     * Set MsgRetainDays value
     * @param int $msgRetainDays
     * @return \StructType\ObsoleteAfterAssertion
     */
    public function setMsgRetainDays($msgRetainDays = null)
    {
        // validation for constraint: int
        if (!is_null($msgRetainDays) && !(is_int($msgRetainDays) || ctype_digit($msgRetainDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($msgRetainDays, true), gettype($msgRetainDays)), __LINE__);
        }
        $this->MsgRetainDays = $msgRetainDays;
        return $this;
    }
    /**
     * Get WarningBeforeMsgObsolete value
     * @return int|null
     */
    public function getWarningBeforeMsgObsolete()
    {
        return $this->WarningBeforeMsgObsolete;
    }
    /**
     * Set WarningBeforeMsgObsolete value
     * @param int $warningBeforeMsgObsolete
     * @return \StructType\ObsoleteAfterAssertion
     */
    public function setWarningBeforeMsgObsolete($warningBeforeMsgObsolete = null)
    {
        // validation for constraint: int
        if (!is_null($warningBeforeMsgObsolete) && !(is_int($warningBeforeMsgObsolete) || ctype_digit($warningBeforeMsgObsolete))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($warningBeforeMsgObsolete, true), gettype($warningBeforeMsgObsolete)), __LINE__);
        }
        $this->WarningBeforeMsgObsolete = $warningBeforeMsgObsolete;
        return $this;
    }
    /**
     * Get PolicyRef value
     * @return string|null
     */
    public function getPolicyRef()
    {
        return $this->PolicyRef;
    }
    /**
     * Set PolicyRef value
     * @param string $policyRef
     * @return \StructType\ObsoleteAfterAssertion
     */
    public function setPolicyRef($policyRef = null)
    {
        // validation for constraint: string
        if (!is_null($policyRef) && !is_string($policyRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyRef, true), gettype($policyRef)), __LINE__);
        }
        $this->PolicyRef = $policyRef;
        return $this;
    }
}
