<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MsgBoxStatusListRequestType StructType
 * @subpackage Structs
 */
class MsgBoxStatusListRequestType extends MsgBoxRequestType
{
    /**
     * The maxListItems
     * @var int
     */
    public $maxListItems;
    /**
     * The ListForm
     * @var string
     */
    public $ListForm;
    /**
     * Constructor method for MsgBoxStatusListRequestType
     * @uses MsgBoxStatusListRequestType::setMaxListItems()
     * @uses MsgBoxStatusListRequestType::setListForm()
     * @param int $maxListItems
     * @param string $listForm
     */
    public function __construct($maxListItems = null, $listForm = null)
    {
        $this
            ->setMaxListItems($maxListItems)
            ->setListForm($listForm);
    }
    /**
     * Get maxListItems value
     * @return int|null
     */
    public function getMaxListItems()
    {
        return $this->maxListItems;
    }
    /**
     * Set maxListItems value
     * @param int $maxListItems
     * @return \StructType\MsgBoxStatusListRequestType
     */
    public function setMaxListItems($maxListItems = null)
    {
        // validation for constraint: int
        if (!is_null($maxListItems) && !(is_int($maxListItems) || ctype_digit($maxListItems))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxListItems, true), gettype($maxListItems)), __LINE__);
        }
        $this->maxListItems = $maxListItems;
        return $this;
    }
    /**
     * Get ListForm value
     * @return string|null
     */
    public function getListForm()
    {
        return $this->ListForm;
    }
    /**
     * Set ListForm value
     * @param string $listForm
     * @return \StructType\MsgBoxStatusListRequestType
     */
    public function setListForm($listForm = null)
    {
        // validation for constraint: string
        if (!is_null($listForm) && !is_string($listForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listForm, true), gettype($listForm)), __LINE__);
        }
        $this->ListForm = $listForm;
        return $this;
    }
}
