<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageStatusType StructType
 * Meta information extracted from the WSDL
 * - documentation: Gibt die Struktur für die Meldungen (Logging-Informationen) über den Transportverlauf vor. Er sieht Meldungszeilen für Infos, Warnungen und Fehler vor.
 * @subpackage Structs
 */
class MessageStatusType extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Wird durch Sender bzw. Empfänger fortgeschrieben. Wird der TransportReport noch fortgeschrieben, wird er hier mit 0=offen markiert. Nach Abschluss des TransportReports wird nach dem Max-Prinzip der höchste Ampelstatus aus den
     * Elementen ErrorList, WarnList, InfoList hier numerisch dargestellt.0=offen: Die Nachricht befindet sich noch in der Verarbeitung.1=grün: Es sind keine Fehler oder Warnungen aufgetreten.2=gelb: Es sind Warnungen, aber keine kritischen Fehler
     * aufgetreten.3=rot: Es sind kritische Fehler aufgetreten.
     * @var int
     */
    public $Status;
    /**
     * The ErrorList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ErrorList
     */
    public $ErrorList;
    /**
     * The WarnList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\WarnList
     */
    public $WarnList;
    /**
     * The InfoList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\InfoList
     */
    public $InfoList;
    /**
     * Constructor method for MessageStatusType
     * @uses MessageStatusType::setStatus()
     * @uses MessageStatusType::setErrorList()
     * @uses MessageStatusType::setWarnList()
     * @uses MessageStatusType::setInfoList()
     * @param int $status
     * @param \StructType\ErrorList $errorList
     * @param \StructType\WarnList $warnList
     * @param \StructType\InfoList $infoList
     */
    public function __construct($status = null, \StructType\ErrorList $errorList = null, \StructType\WarnList $warnList = null, \StructType\InfoList $infoList = null)
    {
        $this
            ->setStatus($status)
            ->setErrorList($errorList)
            ->setWarnList($warnList)
            ->setInfoList($infoList);
    }
    /**
     * Get Status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \StructType\MessageStatusType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ErrorList value
     * @return \StructType\ErrorList|null
     */
    public function getErrorList()
    {
        return $this->ErrorList;
    }
    /**
     * Set ErrorList value
     * @param \StructType\ErrorList $errorList
     * @return \StructType\MessageStatusType
     */
    public function setErrorList(\StructType\ErrorList $errorList = null)
    {
        $this->ErrorList = $errorList;
        return $this;
    }
    /**
     * Get WarnList value
     * @return \StructType\WarnList|null
     */
    public function getWarnList()
    {
        return $this->WarnList;
    }
    /**
     * Set WarnList value
     * @param \StructType\WarnList $warnList
     * @return \StructType\MessageStatusType
     */
    public function setWarnList(\StructType\WarnList $warnList = null)
    {
        $this->WarnList = $warnList;
        return $this;
    }
    /**
     * Get InfoList value
     * @return \StructType\InfoList|null
     */
    public function getInfoList()
    {
        return $this->InfoList;
    }
    /**
     * Set InfoList value
     * @param \StructType\InfoList $infoList
     * @return \StructType\MessageStatusType
     */
    public function setInfoList(\StructType\InfoList $infoList = null)
    {
        $this->InfoList = $infoList;
        return $this;
    }
}
