<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageMetaData StructType
 * @subpackage Structs
 */
class MessageMetaData extends AbstractStructBase
{
    /**
     * The DeliveryAttributes
     * Meta information extracted from the WSDL
     * - ref: oscimeta:DeliveryAttributes
     * @var \StructType\DeliveryAttributesType
     */
    public $DeliveryAttributes;
    /**
     * The Originators
     * Meta information extracted from the WSDL
     * - ref: oscimeta:Originators
     * @var \StructType\OriginatorsType
     */
    public $Originators;
    /**
     * The Destinations
     * Meta information extracted from the WSDL
     * - ref: oscimeta:Destinations
     * @var \StructType\DestinationsType
     */
    public $Destinations;
    /**
     * The MsgIdentification
     * Meta information extracted from the WSDL
     * - ref: oscimeta:MsgIdentification
     * @var \StructType\MsgIdentificationType
     */
    public $MsgIdentification;
    /**
     * The Qualifier
     * Meta information extracted from the WSDL
     * - ref: oscimeta:Qualifier
     * @var \StructType\QualifierType
     */
    public $Qualifier;
    /**
     * The MessageProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: oscimeta:MessageProperties
     * @var \StructType\MessageProperties
     */
    public $MessageProperties;
    /**
     * The MsgSize
     * Meta information extracted from the WSDL
     * - documentation: Message size in bytes
     * - minOccurs: 0
     * @var int
     */
    public $MsgSize;
    /**
     * The TestMsg
     * Meta information extracted from the WSDL
     * - documentation: "true", if test-message; defaults to "false"
     * - default: false
     * @var bool
     */
    public $TestMsg;
    /**
     * Constructor method for MessageMetaData
     * @uses MessageMetaData::setDeliveryAttributes()
     * @uses MessageMetaData::setOriginators()
     * @uses MessageMetaData::setDestinations()
     * @uses MessageMetaData::setMsgIdentification()
     * @uses MessageMetaData::setQualifier()
     * @uses MessageMetaData::setMessageProperties()
     * @uses MessageMetaData::setMsgSize()
     * @uses MessageMetaData::setTestMsg()
     * @param \StructType\DeliveryAttributesType $deliveryAttributes
     * @param \StructType\OriginatorsType $originators
     * @param \StructType\DestinationsType $destinations
     * @param \StructType\MsgIdentificationType $msgIdentification
     * @param \StructType\QualifierType $qualifier
     * @param \StructType\MessageProperties $messageProperties
     * @param int $msgSize
     * @param bool $testMsg
     */
    public function __construct(\StructType\DeliveryAttributesType $deliveryAttributes = null, \StructType\OriginatorsType $originators = null, \StructType\DestinationsType $destinations = null, \StructType\MsgIdentificationType $msgIdentification = null, \StructType\QualifierType $qualifier = null, \StructType\MessageProperties $messageProperties = null, $msgSize = null, $testMsg = false)
    {
        $this
            ->setDeliveryAttributes($deliveryAttributes)
            ->setOriginators($originators)
            ->setDestinations($destinations)
            ->setMsgIdentification($msgIdentification)
            ->setQualifier($qualifier)
            ->setMessageProperties($messageProperties)
            ->setMsgSize($msgSize)
            ->setTestMsg($testMsg);
    }
    /**
     * Get DeliveryAttributes value
     * @return \StructType\DeliveryAttributesType|null
     */
    public function getDeliveryAttributes()
    {
        return $this->DeliveryAttributes;
    }
    /**
     * Set DeliveryAttributes value
     * @param \StructType\DeliveryAttributesType $deliveryAttributes
     * @return \StructType\MessageMetaData
     */
    public function setDeliveryAttributes(\StructType\DeliveryAttributesType $deliveryAttributes = null)
    {
        $this->DeliveryAttributes = $deliveryAttributes;
        return $this;
    }
    /**
     * Get Originators value
     * @return \StructType\OriginatorsType|null
     */
    public function getOriginators()
    {
        return $this->Originators;
    }
    /**
     * Set Originators value
     * @param \StructType\OriginatorsType $originators
     * @return \StructType\MessageMetaData
     */
    public function setOriginators(\StructType\OriginatorsType $originators = null)
    {
        $this->Originators = $originators;
        return $this;
    }
    /**
     * Get Destinations value
     * @return \StructType\DestinationsType|null
     */
    public function getDestinations()
    {
        return $this->Destinations;
    }
    /**
     * Set Destinations value
     * @param \StructType\DestinationsType $destinations
     * @return \StructType\MessageMetaData
     */
    public function setDestinations(\StructType\DestinationsType $destinations = null)
    {
        $this->Destinations = $destinations;
        return $this;
    }
    /**
     * Get MsgIdentification value
     * @return \StructType\MsgIdentificationType|null
     */
    public function getMsgIdentification()
    {
        return $this->MsgIdentification;
    }
    /**
     * Set MsgIdentification value
     * @param \StructType\MsgIdentificationType $msgIdentification
     * @return \StructType\MessageMetaData
     */
    public function setMsgIdentification(\StructType\MsgIdentificationType $msgIdentification = null)
    {
        $this->MsgIdentification = $msgIdentification;
        return $this;
    }
    /**
     * Get Qualifier value
     * @return \StructType\QualifierType|null
     */
    public function getQualifier()
    {
        return $this->Qualifier;
    }
    /**
     * Set Qualifier value
     * @param \StructType\QualifierType $qualifier
     * @return \StructType\MessageMetaData
     */
    public function setQualifier(\StructType\QualifierType $qualifier = null)
    {
        $this->Qualifier = $qualifier;
        return $this;
    }
    /**
     * Get MessageProperties value
     * @return \StructType\MessageProperties|null
     */
    public function getMessageProperties()
    {
        return $this->MessageProperties;
    }
    /**
     * Set MessageProperties value
     * @param \StructType\MessageProperties $messageProperties
     * @return \StructType\MessageMetaData
     */
    public function setMessageProperties(\StructType\MessageProperties $messageProperties = null)
    {
        $this->MessageProperties = $messageProperties;
        return $this;
    }
    /**
     * Get MsgSize value
     * @return int|null
     */
    public function getMsgSize()
    {
        return $this->MsgSize;
    }
    /**
     * Set MsgSize value
     * @param int $msgSize
     * @return \StructType\MessageMetaData
     */
    public function setMsgSize($msgSize = null)
    {
        // validation for constraint: int
        if (!is_null($msgSize) && !(is_int($msgSize) || ctype_digit($msgSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($msgSize, true), gettype($msgSize)), __LINE__);
        }
        $this->MsgSize = $msgSize;
        return $this;
    }
    /**
     * Get TestMsg value
     * @return bool|null
     */
    public function getTestMsg()
    {
        return $this->TestMsg;
    }
    /**
     * Set TestMsg value
     * @param bool $testMsg
     * @return \StructType\MessageMetaData
     */
    public function setTestMsg($testMsg = false)
    {
        // validation for constraint: boolean
        if (!is_null($testMsg) && !is_bool($testMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($testMsg, true), gettype($testMsg)), __LINE__);
        }
        $this->TestMsg = $testMsg;
        return $this;
    }
}
