<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenericContentContainer StructType
 * Meta information extracted from the WSDL
 * - documentation: Dieses Objekt ist dafür vorgesehen, den Container-Inhalt verschlüsselt zu hinterlegen. Im entschlüsselten Zustand müssen die Daten dem Schwester-Element ContentContainer entsprechen. | Der GenericContentContainer nimmt den zu
 * transportierenden oder abzuliefernden Inhalt auf, z.B. eine XÖV-Nachricht mit ihren Anlagen. Diese Inhalte können unverschlüsselt (Element ContentContainer) oder auch verschlüsselt (Element xenc:EncryptedData) hinterlegt werden. Die
 * Verschlüsselung an dieser Stelle eignet sich für Ende-zu-Ende-Verschlüsselung durch den Autor, wenn dieses Objekt durch den Autor erstellt wird.
 * @subpackage Structs
 */
class GenericContentContainer extends AbstractStructBase
{
    /**
     * The EncryptedData
     * Meta information extracted from the WSDL
     * - choice: EncryptedData | ContentContainer
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - ref: xenc:EncryptedData
     * @var \StructType\EncryptedDataType
     */
    public $EncryptedData;
    /**
     * The ContentContainer
     * Meta information extracted from the WSDL
     * - choice: EncryptedData | ContentContainer
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\ContentContainer
     */
    public $ContentContainer;
    /**
     * Constructor method for GenericContentContainer
     * @uses GenericContentContainer::setEncryptedData()
     * @uses GenericContentContainer::setContentContainer()
     * @param \StructType\EncryptedDataType $encryptedData
     * @param \StructType\ContentContainer $contentContainer
     */
    public function __construct(\StructType\EncryptedDataType $encryptedData = null, \StructType\ContentContainer $contentContainer = null)
    {
        $this
            ->setEncryptedData($encryptedData)
            ->setContentContainer($contentContainer);
    }
    /**
     * Get EncryptedData value
     * @return \StructType\EncryptedDataType|null
     */
    public function getEncryptedData()
    {
        return isset($this->EncryptedData) ? $this->EncryptedData : null;
    }
    /**
     * This method is responsible for validating the value passed to the setEncryptedData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEncryptedData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateEncryptedDataForChoiceConstraintsFromSetEncryptedData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ContentContainer',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property EncryptedData can\'t be set as the property %s is already set. Only one property must be set among these properties: EncryptedData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set EncryptedData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EncryptedDataType $encryptedData
     * @return \StructType\GenericContentContainer
     */
    public function setEncryptedData(\StructType\EncryptedDataType $encryptedData = null)
    {
        // validation for constraint: choice(EncryptedData, ContentContainer)
        if ('' !== ($encryptedDataChoiceErrorMessage = self::validateEncryptedDataForChoiceConstraintsFromSetEncryptedData($encryptedData))) {
            throw new \InvalidArgumentException($encryptedDataChoiceErrorMessage, __LINE__);
        }
        if (is_null($encryptedData) || (is_array($encryptedData) && empty($encryptedData))) {
            unset($this->EncryptedData);
        } else {
            $this->EncryptedData = $encryptedData;
        }
        return $this;
    }
    /**
     * Get ContentContainer value
     * @return \StructType\ContentContainer|null
     */
    public function getContentContainer()
    {
        return isset($this->ContentContainer) ? $this->ContentContainer : null;
    }
    /**
     * This method is responsible for validating the value passed to the setContentContainer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContentContainer method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateContentContainerForChoiceConstraintsFromSetContentContainer($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'EncryptedData',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ContentContainer can\'t be set as the property %s is already set. Only one property must be set among these properties: ContentContainer, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ContentContainer value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ContentContainer $contentContainer
     * @return \StructType\GenericContentContainer
     */
    public function setContentContainer(\StructType\ContentContainer $contentContainer = null)
    {
        // validation for constraint: choice(EncryptedData, ContentContainer)
        if ('' !== ($contentContainerChoiceErrorMessage = self::validateContentContainerForChoiceConstraintsFromSetContentContainer($contentContainer))) {
            throw new \InvalidArgumentException($contentContainerChoiceErrorMessage, __LINE__);
        }
        if (is_null($contentContainer) || (is_array($contentContainer) && empty($contentContainer))) {
            unset($this->ContentContainer);
        } else {
            $this->ContentContainer = $contentContainer;
        }
        return $this;
    }
}
