<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FetchedNotificationType StructType
 * @subpackage Structs
 */
class FetchedNotificationType extends AbstractStructBase
{
    /**
     * The FetchedTime
     * @var string
     */
    public $FetchedTime;
    /**
     * The MessageID
     * Meta information extracted from the WSDL
     * - ref: wsa:MessageID
     * @var \StructType\AttributedURIType
     */
    public $MessageID;
    /**
     * The To
     * Meta information extracted from the WSDL
     * - ref: wsa:To
     * @var \StructType\AttributedURIType
     */
    public $To;
    /**
     * The From
     * Meta information extracted from the WSDL
     * - ref: wsa:From
     * @var \StructType\EndpointReferenceType
     */
    public $From;
    /**
     * Constructor method for FetchedNotificationType
     * @uses FetchedNotificationType::setFetchedTime()
     * @uses FetchedNotificationType::setMessageID()
     * @uses FetchedNotificationType::setTo()
     * @uses FetchedNotificationType::setFrom()
     * @param string $fetchedTime
     * @param \StructType\AttributedURIType $messageID
     * @param \StructType\AttributedURIType $to
     * @param \StructType\EndpointReferenceType $from
     */
    public function __construct($fetchedTime = null, \StructType\AttributedURIType $messageID = null, \StructType\AttributedURIType $to = null, \StructType\EndpointReferenceType $from = null)
    {
        $this
            ->setFetchedTime($fetchedTime)
            ->setMessageID($messageID)
            ->setTo($to)
            ->setFrom($from);
    }
    /**
     * Get FetchedTime value
     * @return string|null
     */
    public function getFetchedTime()
    {
        return $this->FetchedTime;
    }
    /**
     * Set FetchedTime value
     * @param string $fetchedTime
     * @return \StructType\FetchedNotificationType
     */
    public function setFetchedTime($fetchedTime = null)
    {
        // validation for constraint: string
        if (!is_null($fetchedTime) && !is_string($fetchedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fetchedTime, true), gettype($fetchedTime)), __LINE__);
        }
        $this->FetchedTime = $fetchedTime;
        return $this;
    }
    /**
     * Get MessageID value
     * @return \StructType\AttributedURIType|null
     */
    public function getMessageID()
    {
        return $this->MessageID;
    }
    /**
     * Set MessageID value
     * @param \StructType\AttributedURIType $messageID
     * @return \StructType\FetchedNotificationType
     */
    public function setMessageID(\StructType\AttributedURIType $messageID = null)
    {
        $this->MessageID = $messageID;
        return $this;
    }
    /**
     * Get To value
     * @return \StructType\AttributedURIType|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param \StructType\AttributedURIType $to
     * @return \StructType\FetchedNotificationType
     */
    public function setTo(\StructType\AttributedURIType $to = null)
    {
        $this->To = $to;
        return $this;
    }
    /**
     * Get From value
     * @return \StructType\EndpointReferenceType|null
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param \StructType\EndpointReferenceType $from
     * @return \StructType\FetchedNotificationType
     */
    public function setFrom(\StructType\EndpointReferenceType $from = null)
    {
        $this->From = $from;
        return $this;
    }
}
