<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fault StructType
 * Meta information extracted from the WSDL
 * - documentation: Fault reporting structure
 * - final: extension
 * - type: tns:Fault
 * @subpackage Structs
 */
class Fault extends AbstractStructBase
{
    /**
     * The Code
     * @var \StructType\Faultcode
     */
    public $Code;
    /**
     * The Reason
     * @var \StructType\Faultreason
     */
    public $Reason;
    /**
     * The Node
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Node;
    /**
     * The Role
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Role;
    /**
     * The Detail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Detail
     */
    public $Detail;
    /**
     * Constructor method for Fault
     * @uses Fault::setCode()
     * @uses Fault::setReason()
     * @uses Fault::setNode()
     * @uses Fault::setRole()
     * @uses Fault::setDetail()
     * @param \StructType\Faultcode $code
     * @param \StructType\Faultreason $reason
     * @param string $node
     * @param string $role
     * @param \StructType\Detail $detail
     */
    public function __construct(\StructType\Faultcode $code = null, \StructType\Faultreason $reason = null, $node = null, $role = null, \StructType\Detail $detail = null)
    {
        $this
            ->setCode($code)
            ->setReason($reason)
            ->setNode($node)
            ->setRole($role)
            ->setDetail($detail);
    }
    /**
     * Get Code value
     * @return \StructType\Faultcode|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param \StructType\Faultcode $code
     * @return \StructType\Fault
     */
    public function setCode(\StructType\Faultcode $code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Reason value
     * @return \StructType\Faultreason|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param \StructType\Faultreason $reason
     * @return \StructType\Fault
     */
    public function setReason(\StructType\Faultreason $reason = null)
    {
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Get Node value
     * @return string|null
     */
    public function getNode()
    {
        return $this->Node;
    }
    /**
     * Set Node value
     * @param string $node
     * @return \StructType\Fault
     */
    public function setNode($node = null)
    {
        // validation for constraint: string
        if (!is_null($node) && !is_string($node)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($node, true), gettype($node)), __LINE__);
        }
        $this->Node = $node;
        return $this;
    }
    /**
     * Get Role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->Role;
    }
    /**
     * Set Role value
     * @param string $role
     * @return \StructType\Fault
     */
    public function setRole($role = null)
    {
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($role, true), gettype($role)), __LINE__);
        }
        $this->Role = $role;
        return $this;
    }
    /**
     * Get Detail value
     * @return \StructType\Detail|null
     */
    public function getDetail()
    {
        return $this->Detail;
    }
    /**
     * Set Detail value
     * @param \StructType\Detail $detail
     * @return \StructType\Fault
     */
    public function setDetail(\StructType\Detail $detail = null)
    {
        $this->Detail = $detail;
        return $this;
    }
}
