<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorList StructType
 * Meta information extracted from the WSDL
 * - documentation: Liste der Fehlermeldungen.
 * @subpackage Structs
 */
class ErrorList extends AbstractStructBase
{
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - documentation: Hier wird die Fehlermeldung mit ihren Parametern eingetragen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RecordType[]
     */
    public $Error;
    /**
     * Constructor method for ErrorList
     * @uses ErrorList::setError()
     * @param \StructType\RecordType[] $error
     */
    public function __construct(array $error = array())
    {
        $this
            ->setError($error);
    }
    /**
     * Get Error value
     * @return \StructType\RecordType[]|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * This method is responsible for validating the values passed to the setError method
     * This method is willingly generated in order to preserve the one-line inline validation within the setError method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorForArrayConstraintsFromSetError(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $errorListErrorItem) {
            // validation for constraint: itemType
            if (!$errorListErrorItem instanceof \StructType\RecordType) {
                $invalidValues[] = is_object($errorListErrorItem) ? get_class($errorListErrorItem) : sprintf('%s(%s)', gettype($errorListErrorItem), var_export($errorListErrorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Error property can only contain items of type \StructType\RecordType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Error value
     * @throws \InvalidArgumentException
     * @param \StructType\RecordType[] $error
     * @return \StructType\ErrorList
     */
    public function setError(array $error = array())
    {
        // validation for constraint: array
        if ('' !== ($errorArrayErrorMessage = self::validateErrorForArrayConstraintsFromSetError($error))) {
            throw new \InvalidArgumentException($errorArrayErrorMessage, __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Add item to Error value
     * @throws \InvalidArgumentException
     * @param \StructType\RecordType $item
     * @return \StructType\ErrorList
     */
    public function addToError(\StructType\RecordType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RecordType) {
            throw new \InvalidArgumentException(sprintf('The Error property can only contain items of type \StructType\RecordType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Error[] = $item;
        return $this;
    }
}
