<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryAttributesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Timestamps, priority etc. | Message delivery time instants, quality and receipts requested
 * @subpackage Structs
 */
class DeliveryAttributesType extends AbstractStructBase
{
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - documentation: Production of content by Requester respective (response) Provider
     * - minOccurs: 0
     * @var string
     */
    public $Origin;
    /**
     * The InitialSend
     * Meta information extracted from the WSDL
     * - documentation: Time when delivery was started (submission by Senders node)
     * - minOccurs: 0
     * @var string
     */
    public $InitialSend;
    /**
     * The NotBefore
     * Meta information extracted from the WSDL
     * - documentation: Time when sending node should submit message
     * - minOccurs: 0
     * @var string
     */
    public $NotBefore;
    /**
     * The ObsoleteAfter
     * Meta information extracted from the WSDL
     * - documentation: Date, when this message is obsolete; may be set by Initiator
     * - minOccurs: 0
     * @var string
     */
    public $ObsoleteAfter;
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - documentation: Time of entry in a Recipients MsgBox or reception by Recipient in synchronous case
     * - minOccurs: 0
     * @var string
     */
    public $Delivery;
    /**
     * The InitialFetch
     * Meta information extracted from the WSDL
     * - documentation: Time of first comitted fetch from MsgBox by recipient
     * - minOccurs: 0
     * @var string
     */
    public $InitialFetch;
    /**
     * The Reception
     * Meta information extracted from the WSDL
     * - documentation: Reception time set by the Ultimate Recipient ("Reader", target application)
     * - minOccurs: 0
     * @var string
     */
    public $Reception;
    /**
     * The ServiceQuality
     * Meta information extracted from the WSDL
     * - documentation: Property like priority etc. - XTA here points to "Service Profile"
     * - base: xs:string
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceQuality;
    /**
     * The ReceiptRequests
     * Meta information extracted from the WSDL
     * - documentation: Receipts requested by sender or author
     * - minOccurs: 0
     * @var \StructType\ReceiptRequestType
     */
    public $ReceiptRequests;
    /**
     * Constructor method for DeliveryAttributesType
     * @uses DeliveryAttributesType::setOrigin()
     * @uses DeliveryAttributesType::setInitialSend()
     * @uses DeliveryAttributesType::setNotBefore()
     * @uses DeliveryAttributesType::setObsoleteAfter()
     * @uses DeliveryAttributesType::setDelivery()
     * @uses DeliveryAttributesType::setInitialFetch()
     * @uses DeliveryAttributesType::setReception()
     * @uses DeliveryAttributesType::setServiceQuality()
     * @uses DeliveryAttributesType::setReceiptRequests()
     * @param string $origin
     * @param string $initialSend
     * @param string $notBefore
     * @param string $obsoleteAfter
     * @param string $delivery
     * @param string $initialFetch
     * @param string $reception
     * @param string $serviceQuality
     * @param \StructType\ReceiptRequestType $receiptRequests
     */
    public function __construct($origin = null, $initialSend = null, $notBefore = null, $obsoleteAfter = null, $delivery = null, $initialFetch = null, $reception = null, $serviceQuality = null, \StructType\ReceiptRequestType $receiptRequests = null)
    {
        $this
            ->setOrigin($origin)
            ->setInitialSend($initialSend)
            ->setNotBefore($notBefore)
            ->setObsoleteAfter($obsoleteAfter)
            ->setDelivery($delivery)
            ->setInitialFetch($initialFetch)
            ->setReception($reception)
            ->setServiceQuality($serviceQuality)
            ->setReceiptRequests($receiptRequests);
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\DeliveryAttributesType
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get InitialSend value
     * @return string|null
     */
    public function getInitialSend()
    {
        return $this->InitialSend;
    }
    /**
     * Set InitialSend value
     * @param string $initialSend
     * @return \StructType\DeliveryAttributesType
     */
    public function setInitialSend($initialSend = null)
    {
        // validation for constraint: string
        if (!is_null($initialSend) && !is_string($initialSend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initialSend, true), gettype($initialSend)), __LINE__);
        }
        $this->InitialSend = $initialSend;
        return $this;
    }
    /**
     * Get NotBefore value
     * @return string|null
     */
    public function getNotBefore()
    {
        return $this->NotBefore;
    }
    /**
     * Set NotBefore value
     * @param string $notBefore
     * @return \StructType\DeliveryAttributesType
     */
    public function setNotBefore($notBefore = null)
    {
        // validation for constraint: string
        if (!is_null($notBefore) && !is_string($notBefore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notBefore, true), gettype($notBefore)), __LINE__);
        }
        $this->NotBefore = $notBefore;
        return $this;
    }
    /**
     * Get ObsoleteAfter value
     * @return string|null
     */
    public function getObsoleteAfter()
    {
        return $this->ObsoleteAfter;
    }
    /**
     * Set ObsoleteAfter value
     * @param string $obsoleteAfter
     * @return \StructType\DeliveryAttributesType
     */
    public function setObsoleteAfter($obsoleteAfter = null)
    {
        // validation for constraint: string
        if (!is_null($obsoleteAfter) && !is_string($obsoleteAfter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($obsoleteAfter, true), gettype($obsoleteAfter)), __LINE__);
        }
        $this->ObsoleteAfter = $obsoleteAfter;
        return $this;
    }
    /**
     * Get Delivery value
     * @return string|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }
    /**
     * Set Delivery value
     * @param string $delivery
     * @return \StructType\DeliveryAttributesType
     */
    public function setDelivery($delivery = null)
    {
        // validation for constraint: string
        if (!is_null($delivery) && !is_string($delivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delivery, true), gettype($delivery)), __LINE__);
        }
        $this->Delivery = $delivery;
        return $this;
    }
    /**
     * Get InitialFetch value
     * @return string|null
     */
    public function getInitialFetch()
    {
        return $this->InitialFetch;
    }
    /**
     * Set InitialFetch value
     * @param string $initialFetch
     * @return \StructType\DeliveryAttributesType
     */
    public function setInitialFetch($initialFetch = null)
    {
        // validation for constraint: string
        if (!is_null($initialFetch) && !is_string($initialFetch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initialFetch, true), gettype($initialFetch)), __LINE__);
        }
        $this->InitialFetch = $initialFetch;
        return $this;
    }
    /**
     * Get Reception value
     * @return string|null
     */
    public function getReception()
    {
        return $this->Reception;
    }
    /**
     * Set Reception value
     * @param string $reception
     * @return \StructType\DeliveryAttributesType
     */
    public function setReception($reception = null)
    {
        // validation for constraint: string
        if (!is_null($reception) && !is_string($reception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reception, true), gettype($reception)), __LINE__);
        }
        $this->Reception = $reception;
        return $this;
    }
    /**
     * Get ServiceQuality value
     * @return string|null
     */
    public function getServiceQuality()
    {
        return $this->ServiceQuality;
    }
    /**
     * Set ServiceQuality value
     * @param string $serviceQuality
     * @return \StructType\DeliveryAttributesType
     */
    public function setServiceQuality($serviceQuality = null)
    {
        // validation for constraint: string
        if (!is_null($serviceQuality) && !is_string($serviceQuality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceQuality, true), gettype($serviceQuality)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($serviceQuality) && mb_strlen($serviceQuality) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($serviceQuality)), __LINE__);
        }
        $this->ServiceQuality = $serviceQuality;
        return $this;
    }
    /**
     * Get ReceiptRequests value
     * @return \StructType\ReceiptRequestType|null
     */
    public function getReceiptRequests()
    {
        return $this->ReceiptRequests;
    }
    /**
     * Set ReceiptRequests value
     * @param \StructType\ReceiptRequestType $receiptRequests
     * @return \StructType\DeliveryAttributesType
     */
    public function setReceiptRequests(\StructType\ReceiptRequestType $receiptRequests = null)
    {
        $this->ReceiptRequests = $receiptRequests;
        return $this;
    }
}
