<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContentContainer StructType
 * Meta information extracted from the WSDL
 * - documentation: Der ContentContainer enthält genau eine Nachricht (Element Message) und null bis beliebig viele Anlagen, die alle in technisch neutraler Darstellung (base64-kodiert) eingefügt werden (Element Attachment). Die Gesamtgröße des
 * Containers darf 40 MB nicht überschreiten.
 * @subpackage Structs
 */
class ContentContainer extends AbstractStructBase
{
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - documentation: Enthält den base64-kodierten Inhalt, der zwischen WebService-Client und XTA-Server transportiert wird. Die Attribute sind der MIME-Spezifikation (RFC 2183) entnommen.Die zu übermittelnde Nachricht als primärer Inhalt dieses
     * Containers ist optional durch Anhänge (Element Attachment) zu ergänzen. In die Attribute wird je nach Kontext Metainformation zur Nachricht eingetragen.
     * @var \StructType\ContentType
     */
    public $Message;
    /**
     * The Attachment
     * Meta information extracted from the WSDL
     * - documentation: Hier können optional ergänzende Anhänge zur übermittelnden Nachricht eingefügt werden. Die Attribute transportieren je nach Kontext Metainformation zum enthaltenen Anhang.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContentType[]
     */
    public $Attachment;
    /**
     * Constructor method for ContentContainer
     * @uses ContentContainer::setMessage()
     * @uses ContentContainer::setAttachment()
     * @param \StructType\ContentType $message
     * @param \StructType\ContentType[] $attachment
     */
    public function __construct(\StructType\ContentType $message = null, array $attachment = array())
    {
        $this
            ->setMessage($message)
            ->setAttachment($attachment);
    }
    /**
     * Get Message value
     * @return \StructType\ContentType|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param \StructType\ContentType $message
     * @return \StructType\ContentContainer
     */
    public function setMessage(\StructType\ContentType $message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Attachment value
     * @return \StructType\ContentType[]|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachmentForArrayConstraintsFromSetAttachment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contentContainerAttachmentItem) {
            // validation for constraint: itemType
            if (!$contentContainerAttachmentItem instanceof \StructType\ContentType) {
                $invalidValues[] = is_object($contentContainerAttachmentItem) ? get_class($contentContainerAttachmentItem) : sprintf('%s(%s)', gettype($contentContainerAttachmentItem), var_export($contentContainerAttachmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment property can only contain items of type \StructType\ContentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\ContentType[] $attachment
     * @return \StructType\ContentContainer
     */
    public function setAttachment(array $attachment = array())
    {
        // validation for constraint: array
        if ('' !== ($attachmentArrayErrorMessage = self::validateAttachmentForArrayConstraintsFromSetAttachment($attachment))) {
            throw new \InvalidArgumentException($attachmentArrayErrorMessage, __LINE__);
        }
        $this->Attachment = $attachment;
        return $this;
    }
    /**
     * Add item to Attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\ContentType $item
     * @return \StructType\ContentContainer
     */
    public function addToAttachment(\StructType\ContentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContentType) {
            throw new \InvalidArgumentException(sprintf('The Attachment property can only contain items of type \StructType\ContentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment[] = $item;
        return $this;
    }
}
