<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CipherDataType StructType
 * @subpackage Structs
 */
class CipherDataType extends AbstractStructBase
{
    /**
     * The CipherValue
     * Meta information extracted from the WSDL
     * - choice: CipherValue | CipherReference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $CipherValue;
    /**
     * The CipherReference
     * Meta information extracted from the WSDL
     * - choice: CipherValue | CipherReference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - ref: xenc:CipherReference
     * @var \StructType\CipherReferenceType
     */
    public $CipherReference;
    /**
     * Constructor method for CipherDataType
     * @uses CipherDataType::setCipherValue()
     * @uses CipherDataType::setCipherReference()
     * @param string $cipherValue
     * @param \StructType\CipherReferenceType $cipherReference
     */
    public function __construct($cipherValue = null, \StructType\CipherReferenceType $cipherReference = null)
    {
        $this
            ->setCipherValue($cipherValue)
            ->setCipherReference($cipherReference);
    }
    /**
     * Get CipherValue value
     * @return string|null
     */
    public function getCipherValue()
    {
        return isset($this->CipherValue) ? $this->CipherValue : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCipherValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCipherValue method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCipherValueForChoiceConstraintsFromSetCipherValue($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CipherReference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CipherValue can\'t be set as the property %s is already set. Only one property must be set among these properties: CipherValue, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CipherValue value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $cipherValue
     * @return \StructType\CipherDataType
     */
    public function setCipherValue($cipherValue = null)
    {
        // validation for constraint: string
        if (!is_null($cipherValue) && !is_string($cipherValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cipherValue, true), gettype($cipherValue)), __LINE__);
        }
        // validation for constraint: choice(CipherValue, CipherReference)
        if ('' !== ($cipherValueChoiceErrorMessage = self::validateCipherValueForChoiceConstraintsFromSetCipherValue($cipherValue))) {
            throw new \InvalidArgumentException($cipherValueChoiceErrorMessage, __LINE__);
        }
        if (is_null($cipherValue) || (is_array($cipherValue) && empty($cipherValue))) {
            unset($this->CipherValue);
        } else {
            $this->CipherValue = $cipherValue;
        }
        return $this;
    }
    /**
     * Get CipherReference value
     * @return \StructType\CipherReferenceType|null
     */
    public function getCipherReference()
    {
        return isset($this->CipherReference) ? $this->CipherReference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCipherReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCipherReference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCipherReferenceForChoiceConstraintsFromSetCipherReference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CipherValue',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CipherReference can\'t be set as the property %s is already set. Only one property must be set among these properties: CipherReference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CipherReference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CipherReferenceType $cipherReference
     * @return \StructType\CipherDataType
     */
    public function setCipherReference(\StructType\CipherReferenceType $cipherReference = null)
    {
        // validation for constraint: choice(CipherValue, CipherReference)
        if ('' !== ($cipherReferenceChoiceErrorMessage = self::validateCipherReferenceForChoiceConstraintsFromSetCipherReference($cipherReference))) {
            throw new \InvalidArgumentException($cipherReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($cipherReference) || (is_array($cipherReference) && empty($cipherReference))) {
            unset($this->CipherReference);
        } else {
            $this->CipherReference = $cipherReference;
        }
        return $this;
    }
}
