<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the Author SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\PartyType $author
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthor(\StructType\PartyType $author, $nameSpace = 'http://www.osci.eu/ws/2014/10/transport', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Author', $author, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named getMessage
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Author
     * - SOAPHeaderNamespaces: http://www.osci.eu/ws/2014/10/transport
     * - SOAPHeaderTypes: \StructType\PartyType
     * - SOAPHeaders: required
     * - documentation: The getMethode method returns the first message relating to the given parameter | Input: optional xta:AuthorIdentifier header and OSCI 2 MsgBoxFetchRequest parameter in the body part | Output: Header: Optional xta:AuthorIdentifier
     * header or OSCI2 Header MsgBoxResponse with addional information and related GenericContentContainer in the body part
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MsgBoxFetchRequest $fetchRequest
     * @return \StructType\GenericContentContainer|bool
     */
    public function getMessage(\StructType\MsgBoxFetchRequest $fetchRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->getMessage($fetchRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStatusList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Author
     * - SOAPHeaderNamespaces: http://www.osci.eu/ws/2014/10/transport
     * - SOAPHeaderTypes: \StructType\PartyType
     * - SOAPHeaders: required
     * - documentation: getStatusList returns the list of related message information | Input: optional xta:AuthorIdentifier header and OSCI 2 MsgStatusListRequest parameter in the body part | Output: Header: OSCI2 Header MsgBoxResponse with addional
     * information and related MsgStatusList in the body part
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MsgBoxStatusListRequestType $fetchRequest
     * @return \StructType\MsgStatusListType|bool
     */
    public function getStatusList(\StructType\MsgBoxStatusListRequestType $fetchRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->getStatusList($fetchRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNextMessage
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Author
     * - SOAPHeaderNamespaces: http://www.osci.eu/ws/2014/10/transport
     * - SOAPHeaderTypes: \StructType\PartyType
     * - SOAPHeaders: required
     * - documentation: getNextMessage returns next message relates to fetch iterator | Input: Optional xta:AuthorIdentifier header and in the body part the MsgBoxNextRequest element conatining the fetch iterator | Output: Header: Optional
     * xta:AuthorIdentifier header or OSCI2 Header MsgBoxResponse with addional information and related MsgStatusList in the body part
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MsgBoxGetNextRequestType $fetchRequest
     * @return \StructType\GenericContentContainer|bool
     */
    public function getNextMessage(\StructType\MsgBoxGetNextRequestType $fetchRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->getNextMessage($fetchRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNextStatusList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Author
     * - SOAPHeaderNamespaces: http://www.osci.eu/ws/2014/10/transport
     * - SOAPHeaderTypes: \StructType\PartyType
     * - SOAPHeaders: required
     * - documentation: getNextStatusList returns the next list of related message information related to the fetch iterator | Input: optional xta:AuthorIdentifier header and in the body part the MsgBoxNextRequest element conatining the fetch iterator |
     * Output: Header: OSCI2 Header MsgBoxResponse with addional information and next related MsgStatusList in the body part
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MsgBoxGetNextRequestType $fetchRequest
     * @return \StructType\MsgStatusListType|bool
     */
    public function getNextStatusList(\StructType\MsgBoxGetNextRequestType $fetchRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->getNextStatusList($fetchRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTransportReport
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Author
     * - SOAPHeaderNamespaces: http://www.osci.eu/ws/2014/10/transport
     * - SOAPHeaderTypes: \StructType\PartyType
     * - SOAPHeaders: required
     * - documentation: Method to get the transport report for the given MessageID | Input: optional xta:AuthorIdentifier header and the MessageID in the body part. | Output body: The Transport report containing the detailed information for the related
     * message.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AttributedURIType $messageID
     * @return \StructType\TransportReport|bool
     */
    public function getTransportReport(\StructType\AttributedURIType $messageID)
    {
        try {
            $this->setResult($this->getSoapClient()->getTransportReport($messageID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GenericContentContainer|\StructType\MsgStatusListType|\StructType\TransportReport
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
