<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Sets the Author SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\PartyType $author
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthor(\StructType\PartyType $author, $nameSpace = 'http://www.osci.eu/ws/2014/10/transport', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Author', $author, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named cancelMessage
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Author
     * - SOAPHeaderNamespaces: http://www.osci.eu/ws/2014/10/transport
     * - SOAPHeaderTypes: \StructType\PartyType
     * - SOAPHeaders: required
     * - documentation: only for exception handling | Method to cancel disptach order (if not yet finalied successfully) | Input: optional xta:AuthorIdentifier header and the MessageID in the body part. | only for exception handling
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AttributedURIType $messageID
     * @return void|bool
     */
    public function cancelMessage(\StructType\AttributedURIType $messageID)
    {
        try {
            $this->setResult($this->getSoapClient()->cancelMessage($messageID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
