<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for FaultCodesType EnumType
 * @subpackage Enumerations
 */
class FaultCodesType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'tns:InvalidAddressingHeader'
     * @return string 'tns:InvalidAddressingHeader'
     */
    const VALUE_TNS_INVALID_ADDRESSING_HEADER = 'tns:InvalidAddressingHeader';
    /**
     * Constant for value 'tns:InvalidAddress'
     * @return string 'tns:InvalidAddress'
     */
    const VALUE_TNS_INVALID_ADDRESS = 'tns:InvalidAddress';
    /**
     * Constant for value 'tns:InvalidEPR'
     * @return string 'tns:InvalidEPR'
     */
    const VALUE_TNS_INVALID_EPR = 'tns:InvalidEPR';
    /**
     * Constant for value 'tns:InvalidCardinality'
     * @return string 'tns:InvalidCardinality'
     */
    const VALUE_TNS_INVALID_CARDINALITY = 'tns:InvalidCardinality';
    /**
     * Constant for value 'tns:MissingAddressInEPR'
     * @return string 'tns:MissingAddressInEPR'
     */
    const VALUE_TNS_MISSING_ADDRESS_IN_EPR = 'tns:MissingAddressInEPR';
    /**
     * Constant for value 'tns:DuplicateMessageID'
     * @return string 'tns:DuplicateMessageID'
     */
    const VALUE_TNS_DUPLICATE_MESSAGE_ID = 'tns:DuplicateMessageID';
    /**
     * Constant for value 'tns:ActionMismatch'
     * @return string 'tns:ActionMismatch'
     */
    const VALUE_TNS_ACTION_MISMATCH = 'tns:ActionMismatch';
    /**
     * Constant for value 'tns:MessageAddressingHeaderRequired'
     * @return string 'tns:MessageAddressingHeaderRequired'
     */
    const VALUE_TNS_MESSAGE_ADDRESSING_HEADER_REQUIRED = 'tns:MessageAddressingHeaderRequired';
    /**
     * Constant for value 'tns:DestinationUnreachable'
     * @return string 'tns:DestinationUnreachable'
     */
    const VALUE_TNS_DESTINATION_UNREACHABLE = 'tns:DestinationUnreachable';
    /**
     * Constant for value 'tns:ActionNotSupported'
     * @return string 'tns:ActionNotSupported'
     */
    const VALUE_TNS_ACTION_NOT_SUPPORTED = 'tns:ActionNotSupported';
    /**
     * Constant for value 'tns:EndpointUnavailable'
     * @return string 'tns:EndpointUnavailable'
     */
    const VALUE_TNS_ENDPOINT_UNAVAILABLE = 'tns:EndpointUnavailable';
    /**
     * Return allowed values
     * @uses self::VALUE_TNS_INVALID_ADDRESSING_HEADER
     * @uses self::VALUE_TNS_INVALID_ADDRESS
     * @uses self::VALUE_TNS_INVALID_EPR
     * @uses self::VALUE_TNS_INVALID_CARDINALITY
     * @uses self::VALUE_TNS_MISSING_ADDRESS_IN_EPR
     * @uses self::VALUE_TNS_DUPLICATE_MESSAGE_ID
     * @uses self::VALUE_TNS_ACTION_MISMATCH
     * @uses self::VALUE_TNS_MESSAGE_ADDRESSING_HEADER_REQUIRED
     * @uses self::VALUE_TNS_DESTINATION_UNREACHABLE
     * @uses self::VALUE_TNS_ACTION_NOT_SUPPORTED
     * @uses self::VALUE_TNS_ENDPOINT_UNAVAILABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TNS_INVALID_ADDRESSING_HEADER,
            self::VALUE_TNS_INVALID_ADDRESS,
            self::VALUE_TNS_INVALID_EPR,
            self::VALUE_TNS_INVALID_CARDINALITY,
            self::VALUE_TNS_MISSING_ADDRESS_IN_EPR,
            self::VALUE_TNS_DUPLICATE_MESSAGE_ID,
            self::VALUE_TNS_ACTION_MISMATCH,
            self::VALUE_TNS_MESSAGE_ADDRESSING_HEADER_REQUIRED,
            self::VALUE_TNS_DESTINATION_UNREACHABLE,
            self::VALUE_TNS_ACTION_NOT_SUPPORTED,
            self::VALUE_TNS_ENDPOINT_UNAVAILABLE,
        );
    }
}
