<?php

namespace Dpd\Info\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for all operations
 * @subpackage Services
 */
class Service extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getEventsForCustomerV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Dpd\Info\StructType\GetEventsForCustomerV2 $parameters
     * @return \Dpd\Info\StructType\GetEventsForCustomerV2Response|bool
     */
    public function getEventsForCustomerV2(\Dpd\Info\StructType\GetEventsForCustomerV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEventsForCustomerV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEventsForCustomerV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Dpd\Info\StructType\GetEventsForCustomerV1 $parameters
     * @return \Dpd\Info\StructType\GetEventsForCustomerV1Response|bool
     */
    public function getEventsForCustomerV1(\Dpd\Info\StructType\GetEventsForCustomerV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEventsForCustomerV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEventsForCustomerV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Dpd\Info\StructType\GetEventsForCustomerV3 $parameters
     * @return \Dpd\Info\StructType\GetEventsForCustomerV3Response|bool
     */
    public function getEventsForCustomerV3(\Dpd\Info\StructType\GetEventsForCustomerV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEventsForCustomerV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEventsForCustomerV4
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Dpd\Info\StructType\GetEventsForCustomerV4 $parameters
     * @return \Dpd\Info\StructType\GetEventsForCustomerV4Response|bool
     */
    public function getEventsForCustomerV4(\Dpd\Info\StructType\GetEventsForCustomerV4 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEventsForCustomerV4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEventsForWaybillV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Dpd\Info\StructType\GetEventsForWaybillV1 $parameters
     * @return \Dpd\Info\StructType\GetEventsForWaybillV1Response|bool
     */
    public function getEventsForWaybillV1(\Dpd\Info\StructType\GetEventsForWaybillV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getEventsForWaybillV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named markEventsAsProcessedV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Dpd\Info\StructType\MarkEventsAsProcessedV1 $parameters
     * @return \Dpd\Info\StructType\MarkEventsAsProcessedV1Response|bool
     */
    public function markEventsAsProcessedV1(\Dpd\Info\StructType\MarkEventsAsProcessedV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->markEventsAsProcessedV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Dpd\Info\StructType\GetEventsForCustomerV1Response|\Dpd\Info\StructType\GetEventsForCustomerV2Response|\Dpd\Info\StructType\GetEventsForCustomerV3Response|\Dpd\Info\StructType\GetEventsForCustomerV4Response|\Dpd\Info\StructType\GetEventsForWaybillV1Response|\Dpd\Info\StructType\MarkEventsAsProcessedV1Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
