<?php

namespace Dpd\Info\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customerEventsResponseV1 StructType
 * @subpackage Structs
 */
class CustomerEventsResponseV1 extends AbstractStructBase
{
    /**
     * The confirmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $confirmId;
    /**
     * The eventsList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Dpd\Info\StructType\CustomerEventV1[]
     */
    public $eventsList;
    /**
     * Constructor method for customerEventsResponseV1
     * @uses CustomerEventsResponseV1::setConfirmId()
     * @uses CustomerEventsResponseV1::setEventsList()
     * @param string $confirmId
     * @param \Dpd\Info\StructType\CustomerEventV1[] $eventsList
     */
    public function __construct($confirmId = null, array $eventsList = array())
    {
        $this
            ->setConfirmId($confirmId)
            ->setEventsList($eventsList);
    }
    /**
     * Get confirmId value
     * @return string|null
     */
    public function getConfirmId()
    {
        return $this->confirmId;
    }
    /**
     * Set confirmId value
     * @param string $confirmId
     * @return \Dpd\Info\StructType\CustomerEventsResponseV1
     */
    public function setConfirmId($confirmId = null)
    {
        $this->confirmId = $confirmId;
        return $this;
    }
    /**
     * Get eventsList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Dpd\Info\StructType\CustomerEventV1[]|null
     */
    public function getEventsList()
    {
        return isset($this->eventsList) ? $this->eventsList : null;
    }
    /**
     * Set eventsList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Dpd\Info\StructType\CustomerEventV1[] $eventsList
     * @return \Dpd\Info\StructType\CustomerEventsResponseV1
     */
    public function setEventsList(array $eventsList = array())
    {
        if (is_null($eventsList) || (is_array($eventsList) && empty($eventsList))) {
            unset($this->eventsList);
        } else {
            $this->eventsList = $eventsList;
        }
        return $this;
    }
    /**
     * Add item to eventsList value
     * @throws \InvalidArgumentException
     * @param \Dpd\Info\StructType\CustomerEventV1 $item
     * @return \Dpd\Info\StructType\CustomerEventsResponseV1
     */
    public function addToEventsList(\Dpd\Info\StructType\CustomerEventV1 $item)
    {
        $this->eventsList[] = $item;
        return $this;
    }
}
