<?php

namespace Dpd\Info\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customerEventV3 StructType
 * @subpackage Structs
 */
class CustomerEventV3 extends AbstractStructBase
{
    /**
     * The businessCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $businessCode;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The depot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $depot;
    /**
     * The depotName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $depotName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The eventDataList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Dpd\Info\StructType\CustomerEventDataV3[]
     */
    public $eventDataList;
    /**
     * The eventTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $eventTime;
    /**
     * The objectId
     * @var int
     */
    public $objectId;
    /**
     * The packageReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $packageReference;
    /**
     * The parcelReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $parcelReference;
    /**
     * The waybill
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $waybill;
    /**
     * Constructor method for customerEventV3
     * @uses CustomerEventV3::setBusinessCode()
     * @uses CustomerEventV3::setCountry()
     * @uses CustomerEventV3::setDepot()
     * @uses CustomerEventV3::setDepotName()
     * @uses CustomerEventV3::setDescription()
     * @uses CustomerEventV3::setEventDataList()
     * @uses CustomerEventV3::setEventTime()
     * @uses CustomerEventV3::setObjectId()
     * @uses CustomerEventV3::setPackageReference()
     * @uses CustomerEventV3::setParcelReference()
     * @uses CustomerEventV3::setWaybill()
     * @param string $businessCode
     * @param string $country
     * @param string $depot
     * @param string $depotName
     * @param string $description
     * @param \Dpd\Info\StructType\CustomerEventDataV3[] $eventDataList
     * @param string $eventTime
     * @param int $objectId
     * @param string $packageReference
     * @param string $parcelReference
     * @param string $waybill
     */
    public function __construct($businessCode = null, $country = null, $depot = null, $depotName = null, $description = null, array $eventDataList = array(), $eventTime = null, $objectId = null, $packageReference = null, $parcelReference = null, $waybill = null)
    {
        $this
            ->setBusinessCode($businessCode)
            ->setCountry($country)
            ->setDepot($depot)
            ->setDepotName($depotName)
            ->setDescription($description)
            ->setEventDataList($eventDataList)
            ->setEventTime($eventTime)
            ->setObjectId($objectId)
            ->setPackageReference($packageReference)
            ->setParcelReference($parcelReference)
            ->setWaybill($waybill);
    }
    /**
     * Get businessCode value
     * @return string|null
     */
    public function getBusinessCode()
    {
        return $this->businessCode;
    }
    /**
     * Set businessCode value
     * @param string $businessCode
     * @return \Dpd\Info\StructType\CustomerEventV3
     */
    public function setBusinessCode($businessCode = null)
    {
        $this->businessCode = $businessCode;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \Dpd\Info\StructType\CustomerEventV3
     */
    public function setCountry($country = null)
    {
        $this->country = $country;
        return $this;
    }
    /**
     * Get depot value
     * @return string|null
     */
    public function getDepot()
    {
        return $this->depot;
    }
    /**
     * Set depot value
     * @param string $depot
     * @return \Dpd\Info\StructType\CustomerEventV3
     */
    public function setDepot($depot = null)
    {
        $this->depot = $depot;
        return $this;
    }
    /**
     * Get depotName value
     * @return string|null
     */
    public function getDepotName()
    {
        return $this->depotName;
    }
    /**
     * Set depotName value
     * @param string $depotName
     * @return \Dpd\Info\StructType\CustomerEventV3
     */
    public function setDepotName($depotName = null)
    {
        $this->depotName = $depotName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Dpd\Info\StructType\CustomerEventV3
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get eventDataList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Dpd\Info\StructType\CustomerEventDataV3[]|null
     */
    public function getEventDataList()
    {
        return isset($this->eventDataList) ? $this->eventDataList : null;
    }
    /**
     * Set eventDataList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Dpd\Info\StructType\CustomerEventDataV3[] $eventDataList
     * @return \Dpd\Info\StructType\CustomerEventV3
     */
    public function setEventDataList(array $eventDataList = array())
    {
        if (is_null($eventDataList) || (is_array($eventDataList) && empty($eventDataList))) {
            unset($this->eventDataList);
        } else {
            $this->eventDataList = $eventDataList;
        }
        return $this;
    }
    /**
     * Add item to eventDataList value
     * @throws \InvalidArgumentException
     * @param \Dpd\Info\StructType\CustomerEventDataV3 $item
     * @return \Dpd\Info\StructType\CustomerEventV3
     */
    public function addToEventDataList(\Dpd\Info\StructType\CustomerEventDataV3 $item)
    {
        $this->eventDataList[] = $item;
        return $this;
    }
    /**
     * Get eventTime value
     * @return string|null
     */
    public function getEventTime()
    {
        return $this->eventTime;
    }
    /**
     * Set eventTime value
     * @param string $eventTime
     * @return \Dpd\Info\StructType\CustomerEventV3
     */
    public function setEventTime($eventTime = null)
    {
        $this->eventTime = $eventTime;
        return $this;
    }
    /**
     * Get objectId value
     * @return int|null
     */
    public function getObjectId()
    {
        return $this->objectId;
    }
    /**
     * Set objectId value
     * @param int $objectId
     * @return \Dpd\Info\StructType\CustomerEventV3
     */
    public function setObjectId($objectId = null)
    {
        $this->objectId = $objectId;
        return $this;
    }
    /**
     * Get packageReference value
     * @return string|null
     */
    public function getPackageReference()
    {
        return $this->packageReference;
    }
    /**
     * Set packageReference value
     * @param string $packageReference
     * @return \Dpd\Info\StructType\CustomerEventV3
     */
    public function setPackageReference($packageReference = null)
    {
        $this->packageReference = $packageReference;
        return $this;
    }
    /**
     * Get parcelReference value
     * @return string|null
     */
    public function getParcelReference()
    {
        return $this->parcelReference;
    }
    /**
     * Set parcelReference value
     * @param string $parcelReference
     * @return \Dpd\Info\StructType\CustomerEventV3
     */
    public function setParcelReference($parcelReference = null)
    {
        $this->parcelReference = $parcelReference;
        return $this;
    }
    /**
     * Get waybill value
     * @return string|null
     */
    public function getWaybill()
    {
        return $this->waybill;
    }
    /**
     * Set waybill value
     * @param string $waybill
     * @return \Dpd\Info\StructType\CustomerEventV3
     */
    public function setWaybill($waybill = null)
    {
        $this->waybill = $waybill;
        return $this;
    }
}
