<?php

namespace Dpd\Info\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for customerEventV2 StructType
 * @subpackage Structs
 */
class CustomerEventV2 extends AbstractStructBase
{
    /**
     * The businessCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $businessCode;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The depot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $depot;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The eventDataList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Dpd\Info\StructType\CustomerEventDataV2[]
     */
    public $eventDataList;
    /**
     * The eventTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $eventTime;
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The objectId
     * @var int
     */
    public $objectId;
    /**
     * The operationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $operationType;
    /**
     * The packageReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $packageReference;
    /**
     * The parcelReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $parcelReference;
    /**
     * The waybill
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $waybill;
    /**
     * Constructor method for customerEventV2
     * @uses CustomerEventV2::setBusinessCode()
     * @uses CustomerEventV2::setCountry()
     * @uses CustomerEventV2::setDepot()
     * @uses CustomerEventV2::setDescription()
     * @uses CustomerEventV2::setEventDataList()
     * @uses CustomerEventV2::setEventTime()
     * @uses CustomerEventV2::setId()
     * @uses CustomerEventV2::setObjectId()
     * @uses CustomerEventV2::setOperationType()
     * @uses CustomerEventV2::setPackageReference()
     * @uses CustomerEventV2::setParcelReference()
     * @uses CustomerEventV2::setWaybill()
     * @param string $businessCode
     * @param string $country
     * @param string $depot
     * @param string $description
     * @param \Dpd\Info\StructType\CustomerEventDataV2[] $eventDataList
     * @param string $eventTime
     * @param int $id
     * @param int $objectId
     * @param string $operationType
     * @param string $packageReference
     * @param string $parcelReference
     * @param string $waybill
     */
    public function __construct($businessCode = null, $country = null, $depot = null, $description = null, array $eventDataList = array(), $eventTime = null, $id = null, $objectId = null, $operationType = null, $packageReference = null, $parcelReference = null, $waybill = null)
    {
        $this
            ->setBusinessCode($businessCode)
            ->setCountry($country)
            ->setDepot($depot)
            ->setDescription($description)
            ->setEventDataList($eventDataList)
            ->setEventTime($eventTime)
            ->setId($id)
            ->setObjectId($objectId)
            ->setOperationType($operationType)
            ->setPackageReference($packageReference)
            ->setParcelReference($parcelReference)
            ->setWaybill($waybill);
    }
    /**
     * Get businessCode value
     * @return string|null
     */
    public function getBusinessCode()
    {
        return $this->businessCode;
    }
    /**
     * Set businessCode value
     * @param string $businessCode
     * @return \Dpd\Info\StructType\CustomerEventV2
     */
    public function setBusinessCode($businessCode = null)
    {
        $this->businessCode = $businessCode;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \Dpd\Info\StructType\CustomerEventV2
     */
    public function setCountry($country = null)
    {
        $this->country = $country;
        return $this;
    }
    /**
     * Get depot value
     * @return string|null
     */
    public function getDepot()
    {
        return $this->depot;
    }
    /**
     * Set depot value
     * @param string $depot
     * @return \Dpd\Info\StructType\CustomerEventV2
     */
    public function setDepot($depot = null)
    {
        $this->depot = $depot;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Dpd\Info\StructType\CustomerEventV2
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get eventDataList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Dpd\Info\StructType\CustomerEventDataV2[]|null
     */
    public function getEventDataList()
    {
        return isset($this->eventDataList) ? $this->eventDataList : null;
    }
    /**
     * Set eventDataList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Dpd\Info\StructType\CustomerEventDataV2[] $eventDataList
     * @return \Dpd\Info\StructType\CustomerEventV2
     */
    public function setEventDataList(array $eventDataList = array())
    {
        if (is_null($eventDataList) || (is_array($eventDataList) && empty($eventDataList))) {
            unset($this->eventDataList);
        } else {
            $this->eventDataList = $eventDataList;
        }
        return $this;
    }
    /**
     * Add item to eventDataList value
     * @throws \InvalidArgumentException
     * @param \Dpd\Info\StructType\CustomerEventDataV2 $item
     * @return \Dpd\Info\StructType\CustomerEventV2
     */
    public function addToEventDataList(\Dpd\Info\StructType\CustomerEventDataV2 $item)
    {
        $this->eventDataList[] = $item;
        return $this;
    }
    /**
     * Get eventTime value
     * @return string|null
     */
    public function getEventTime()
    {
        return $this->eventTime;
    }
    /**
     * Set eventTime value
     * @param string $eventTime
     * @return \Dpd\Info\StructType\CustomerEventV2
     */
    public function setEventTime($eventTime = null)
    {
        $this->eventTime = $eventTime;
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \Dpd\Info\StructType\CustomerEventV2
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get objectId value
     * @return int|null
     */
    public function getObjectId()
    {
        return $this->objectId;
    }
    /**
     * Set objectId value
     * @param int $objectId
     * @return \Dpd\Info\StructType\CustomerEventV2
     */
    public function setObjectId($objectId = null)
    {
        $this->objectId = $objectId;
        return $this;
    }
    /**
     * Get operationType value
     * @return string|null
     */
    public function getOperationType()
    {
        return $this->operationType;
    }
    /**
     * Set operationType value
     * @param string $operationType
     * @return \Dpd\Info\StructType\CustomerEventV2
     */
    public function setOperationType($operationType = null)
    {
        $this->operationType = $operationType;
        return $this;
    }
    /**
     * Get packageReference value
     * @return string|null
     */
    public function getPackageReference()
    {
        return $this->packageReference;
    }
    /**
     * Set packageReference value
     * @param string $packageReference
     * @return \Dpd\Info\StructType\CustomerEventV2
     */
    public function setPackageReference($packageReference = null)
    {
        $this->packageReference = $packageReference;
        return $this;
    }
    /**
     * Get parcelReference value
     * @return string|null
     */
    public function getParcelReference()
    {
        return $this->parcelReference;
    }
    /**
     * Set parcelReference value
     * @param string $parcelReference
     * @return \Dpd\Info\StructType\CustomerEventV2
     */
    public function setParcelReference($parcelReference = null)
    {
        $this->parcelReference = $parcelReference;
        return $this;
    }
    /**
     * Get waybill value
     * @return string|null
     */
    public function getWaybill()
    {
        return $this->waybill;
    }
    /**
     * Set waybill value
     * @param string $waybill
     * @return \Dpd\Info\StructType\CustomerEventV2
     */
    public function setWaybill($waybill = null)
    {
        $this->waybill = $waybill;
        return $this;
    }
}
