<?php

namespace Dpd\App\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for statusInfoPIMV1 StructType
 * @subpackage Structs
 */
class StatusInfoPIMV1 extends AbstractStructBase
{
    /**
     * The errorDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Dpd\App\StructType\ErrorDetailsPIMV1[]
     */
    public $errorDetails;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * Constructor method for statusInfoPIMV1
     * @uses StatusInfoPIMV1::setErrorDetails()
     * @uses StatusInfoPIMV1::setStatus()
     * @param \Dpd\App\StructType\ErrorDetailsPIMV1[] $errorDetails
     * @param string $status
     */
    public function __construct(array $errorDetails = array(), $status = null)
    {
        $this
            ->setErrorDetails($errorDetails)
            ->setStatus($status);
    }
    /**
     * Get errorDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Dpd\App\StructType\ErrorDetailsPIMV1[]|null
     */
    public function getErrorDetails()
    {
        return isset($this->errorDetails) ? $this->errorDetails : null;
    }
    /**
     * Set errorDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Dpd\App\StructType\ErrorDetailsPIMV1[] $errorDetails
     * @return \Dpd\App\StructType\StatusInfoPIMV1
     */
    public function setErrorDetails(array $errorDetails = array())
    {
        if (is_null($errorDetails) || (is_array($errorDetails) && empty($errorDetails))) {
            unset($this->errorDetails);
        } else {
            $this->errorDetails = $errorDetails;
        }
        return $this;
    }
    /**
     * Add item to errorDetails value
     * @throws \InvalidArgumentException
     * @param \Dpd\App\StructType\ErrorDetailsPIMV1 $item
     * @return \Dpd\App\StructType\StatusInfoPIMV1
     */
    public function addToErrorDetails(\Dpd\App\StructType\ErrorDetailsPIMV1 $item)
    {
        $this->errorDetails[] = $item;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \Dpd\App\StructType\StatusInfoPIMV1
     */
    public function setStatus($status = null)
    {
        $this->status = $status;
        return $this;
    }
}
