<?php

namespace Dpd\App\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcelPIMV1 StructType
 * @subpackage Structs
 */
class ParcelPIMV1 extends AbstractStructBase
{
    /**
     * The parcelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $parcelId;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * The statusInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Dpd\App\StructType\StatusInfoPIMV1
     */
    public $statusInfo;
    /**
     * The waybill
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $waybill;
    /**
     * Constructor method for parcelPIMV1
     * @uses ParcelPIMV1::setParcelId()
     * @uses ParcelPIMV1::setReference()
     * @uses ParcelPIMV1::setStatusInfo()
     * @uses ParcelPIMV1::setWaybill()
     * @param int $parcelId
     * @param string $reference
     * @param \Dpd\App\StructType\StatusInfoPIMV1 $statusInfo
     * @param string $waybill
     */
    public function __construct($parcelId = null, $reference = null, \Dpd\App\StructType\StatusInfoPIMV1 $statusInfo = null, $waybill = null)
    {
        $this
            ->setParcelId($parcelId)
            ->setReference($reference)
            ->setStatusInfo($statusInfo)
            ->setWaybill($waybill);
    }
    /**
     * Get parcelId value
     * @return int|null
     */
    public function getParcelId()
    {
        return $this->parcelId;
    }
    /**
     * Set parcelId value
     * @param int $parcelId
     * @return \Dpd\App\StructType\ParcelPIMV1
     */
    public function setParcelId($parcelId = null)
    {
        $this->parcelId = $parcelId;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \Dpd\App\StructType\ParcelPIMV1
     */
    public function setReference($reference = null)
    {
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get statusInfo value
     * @return \Dpd\App\StructType\StatusInfoPIMV1|null
     */
    public function getStatusInfo()
    {
        return $this->statusInfo;
    }
    /**
     * Set statusInfo value
     * @param \Dpd\App\StructType\StatusInfoPIMV1 $statusInfo
     * @return \Dpd\App\StructType\ParcelPIMV1
     */
    public function setStatusInfo(\Dpd\App\StructType\StatusInfoPIMV1 $statusInfo = null)
    {
        $this->statusInfo = $statusInfo;
        return $this;
    }
    /**
     * Get waybill value
     * @return string|null
     */
    public function getWaybill()
    {
        return $this->waybill;
    }
    /**
     * Set waybill value
     * @param string $waybill
     * @return \Dpd\App\StructType\ParcelPIMV1
     */
    public function setWaybill($waybill = null)
    {
        $this->waybill = $waybill;
        return $this;
    }
}
