<?php

namespace Dpd\App\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for all operations
 * @subpackage Services
 */
class Service extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named importPackagesV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Dpd\App\StructType\ImportPackagesV1 $parameters
     * @return \Dpd\App\StructType\ImportPackagesV1Response|bool
     */
    public function importPackagesV1(\Dpd\App\StructType\ImportPackagesV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->importPackagesV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named importCROUTPackageStatusV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Dpd\App\StructType\ImportCROUTPackageStatusV1 $parameters
     * @return \Dpd\App\StructType\ImportCROUTPackageStatusV1Response|bool
     */
    public function importCROUTPackageStatusV1(\Dpd\App\StructType\ImportCROUTPackageStatusV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->importCROUTPackageStatusV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Dpd\App\StructType\ImportCROUTPackageStatusV1Response|\Dpd\App\StructType\ImportPackagesV1Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
