<?php

namespace Dpd\App\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sessionPIMV1 StructType
 * @subpackage Structs
 */
class SessionPIMV1 extends AbstractStructBase
{
    /**
     * The beginTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $beginTime;
    /**
     * The endTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endTime;
    /**
     * The packages
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Dpd\App\StructType\PackagePIMV1[]
     */
    public $packages;
    /**
     * The sessionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sessionId;
    /**
     * The statusInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Dpd\App\StructType\StatusInfoPIMV1
     */
    public $statusInfo;
    /**
     * Constructor method for sessionPIMV1
     * @uses SessionPIMV1::setBeginTime()
     * @uses SessionPIMV1::setEndTime()
     * @uses SessionPIMV1::setPackages()
     * @uses SessionPIMV1::setSessionId()
     * @uses SessionPIMV1::setStatusInfo()
     * @param string $beginTime
     * @param string $endTime
     * @param \Dpd\App\StructType\PackagePIMV1[] $packages
     * @param int $sessionId
     * @param \Dpd\App\StructType\StatusInfoPIMV1 $statusInfo
     */
    public function __construct($beginTime = null, $endTime = null, array $packages = array(), $sessionId = null, \Dpd\App\StructType\StatusInfoPIMV1 $statusInfo = null)
    {
        $this
            ->setBeginTime($beginTime)
            ->setEndTime($endTime)
            ->setPackages($packages)
            ->setSessionId($sessionId)
            ->setStatusInfo($statusInfo);
    }
    /**
     * Get beginTime value
     * @return string|null
     */
    public function getBeginTime()
    {
        return $this->beginTime;
    }
    /**
     * Set beginTime value
     * @param string $beginTime
     * @return \Dpd\App\StructType\SessionPIMV1
     */
    public function setBeginTime($beginTime = null)
    {
        $this->beginTime = $beginTime;
        return $this;
    }
    /**
     * Get endTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->endTime;
    }
    /**
     * Set endTime value
     * @param string $endTime
     * @return \Dpd\App\StructType\SessionPIMV1
     */
    public function setEndTime($endTime = null)
    {
        $this->endTime = $endTime;
        return $this;
    }
    /**
     * Get packages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Dpd\App\StructType\PackagePIMV1[]|null
     */
    public function getPackages()
    {
        return isset($this->packages) ? $this->packages : null;
    }
    /**
     * Set packages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Dpd\App\StructType\PackagePIMV1[] $packages
     * @return \Dpd\App\StructType\SessionPIMV1
     */
    public function setPackages(array $packages = array())
    {
        if (is_null($packages) || (is_array($packages) && empty($packages))) {
            unset($this->packages);
        } else {
            $this->packages = $packages;
        }
        return $this;
    }
    /**
     * Add item to packages value
     * @throws \InvalidArgumentException
     * @param \Dpd\App\StructType\PackagePIMV1 $item
     * @return \Dpd\App\StructType\SessionPIMV1
     */
    public function addToPackages(\Dpd\App\StructType\PackagePIMV1 $item)
    {
        $this->packages[] = $item;
        return $this;
    }
    /**
     * Get sessionId value
     * @return int|null
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param int $sessionId
     * @return \Dpd\App\StructType\SessionPIMV1
     */
    public function setSessionId($sessionId = null)
    {
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get statusInfo value
     * @return \Dpd\App\StructType\StatusInfoPIMV1|null
     */
    public function getStatusInfo()
    {
        return $this->statusInfo;
    }
    /**
     * Set statusInfo value
     * @param \Dpd\App\StructType\StatusInfoPIMV1 $statusInfo
     * @return \Dpd\App\StructType\SessionPIMV1
     */
    public function setStatusInfo(\Dpd\App\StructType\StatusInfoPIMV1 $statusInfo = null)
    {
        $this->statusInfo = $statusInfo;
        return $this;
    }
}
