<?php

namespace Dpd\App\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for packagePIMV1 StructType
 * @subpackage Structs
 */
class PackagePIMV1 extends AbstractStructBase
{
    /**
     * The orderNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderNumber;
    /**
     * The packageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $packageId;
    /**
     * The parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Dpd\App\StructType\ParcelPIMV1[]
     */
    public $parcels;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * The statusInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Dpd\App\StructType\StatusInfoPIMV1
     */
    public $statusInfo;
    /**
     * Constructor method for packagePIMV1
     * @uses PackagePIMV1::setOrderNumber()
     * @uses PackagePIMV1::setPackageId()
     * @uses PackagePIMV1::setParcels()
     * @uses PackagePIMV1::setReference()
     * @uses PackagePIMV1::setStatusInfo()
     * @param string $orderNumber
     * @param int $packageId
     * @param \Dpd\App\StructType\ParcelPIMV1[] $parcels
     * @param string $reference
     * @param \Dpd\App\StructType\StatusInfoPIMV1 $statusInfo
     */
    public function __construct($orderNumber = null, $packageId = null, array $parcels = array(), $reference = null, \Dpd\App\StructType\StatusInfoPIMV1 $statusInfo = null)
    {
        $this
            ->setOrderNumber($orderNumber)
            ->setPackageId($packageId)
            ->setParcels($parcels)
            ->setReference($reference)
            ->setStatusInfo($statusInfo);
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \Dpd\App\StructType\PackagePIMV1
     */
    public function setOrderNumber($orderNumber = null)
    {
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get packageId value
     * @return int|null
     */
    public function getPackageId()
    {
        return $this->packageId;
    }
    /**
     * Set packageId value
     * @param int $packageId
     * @return \Dpd\App\StructType\PackagePIMV1
     */
    public function setPackageId($packageId = null)
    {
        $this->packageId = $packageId;
        return $this;
    }
    /**
     * Get parcels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Dpd\App\StructType\ParcelPIMV1[]|null
     */
    public function getParcels()
    {
        return isset($this->parcels) ? $this->parcels : null;
    }
    /**
     * Set parcels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Dpd\App\StructType\ParcelPIMV1[] $parcels
     * @return \Dpd\App\StructType\PackagePIMV1
     */
    public function setParcels(array $parcels = array())
    {
        if (is_null($parcels) || (is_array($parcels) && empty($parcels))) {
            unset($this->parcels);
        } else {
            $this->parcels = $parcels;
        }
        return $this;
    }
    /**
     * Add item to parcels value
     * @throws \InvalidArgumentException
     * @param \Dpd\App\StructType\ParcelPIMV1 $item
     * @return \Dpd\App\StructType\PackagePIMV1
     */
    public function addToParcels(\Dpd\App\StructType\ParcelPIMV1 $item)
    {
        $this->parcels[] = $item;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \Dpd\App\StructType\PackagePIMV1
     */
    public function setReference($reference = null)
    {
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get statusInfo value
     * @return \Dpd\App\StructType\StatusInfoPIMV1|null
     */
    public function getStatusInfo()
    {
        return $this->statusInfo;
    }
    /**
     * Set statusInfo value
     * @param \Dpd\App\StructType\StatusInfoPIMV1 $statusInfo
     * @return \Dpd\App\StructType\PackagePIMV1
     */
    public function setStatusInfo(\Dpd\App\StructType\StatusInfoPIMV1 $statusInfo = null)
    {
        $this->statusInfo = $statusInfo;
        return $this;
    }
}
