<?php

namespace Dpd\App;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'importPackagesV1' => '\\Dpd\\App\\StructType\\ImportPackagesV1',
            'openUMLFe2V1' => '\\Dpd\\App\\StructType\\OpenUMLFe2V1',
            'packageOpenUMLFe2V1' => '\\Dpd\\App\\StructType\\PackageOpenUMLFe2V1',
            'packageCustomerOpenUMLFe2V1' => '\\Dpd\\App\\StructType\\PackageCustomerOpenUMLFe2V1',
            'parcelOpenUMLFe2V1' => '\\Dpd\\App\\StructType\\ParcelOpenUMLFe2V1',
            'packageAddressOpenUMLFe2V1' => '\\Dpd\\App\\StructType\\PackageAddressOpenUMLFe2V1',
            'servicesOpenUMLFe2V1' => '\\Dpd\\App\\StructType\\ServicesOpenUMLFe2V1',
            'serviceCarryInOpenUMLFe2V1' => '\\Dpd\\App\\StructType\\ServiceCarryInOpenUMLFe2V1',
            'serviceCODOpenUMLFe2V1' => '\\Dpd\\App\\StructType\\ServiceCODOpenUMLFe2V1',
            'serviceCUDOpenUMLFe2V1' => '\\Dpd\\App\\StructType\\ServiceCUDOpenUMLFe2V1',
            'serviceDeclaredValueOpenUMLFe2V1' => '\\Dpd\\App\\StructType\\ServiceDeclaredValueOpenUMLFe2V1',
            'serviceDedicatedCRLabelOpenUMLFe2V1' => '\\Dpd\\App\\StructType\\ServiceDedicatedCRLabelOpenUMLFe2V1',
            'serviceDedicatedDeliveryOpenUMLFe2V1' => '\\Dpd\\App\\StructType\\ServiceDedicatedDeliveryOpenUMLFe2V1',
            'serviceDedicatedSortOpenUMLFe2V1' => '\\Dpd\\App\\StructType\\ServiceDedicatedSortOpenUMLFe2V1',
            'servicePalletOpenUMLFe2V1' => '\\Dpd\\App\\StructType\\ServicePalletOpenUMLFe2V1',
            'serviceDutyOpenUMLFe2V1' => '\\Dpd\\App\\StructType\\ServiceDutyOpenUMLFe2V1',
            'serviceGuaranteeOpenUMLFe2V1' => '\\Dpd\\App\\StructType\\ServiceGuaranteeOpenUMLFe2V1',
            'serviceInPersOpenUMLFe2V1' => '\\Dpd\\App\\StructType\\ServiceInPersOpenUMLFe2V1',
            'servicePrivPersOpenUMLFe2V1' => '\\Dpd\\App\\StructType\\ServicePrivPersOpenUMLFe2V1',
            'serviceRODOpenUMLFe2V1' => '\\Dpd\\App\\StructType\\ServiceRODOpenUMLFe2V1',
            'serviceSelfColOpenUMLFe2V1' => '\\Dpd\\App\\StructType\\ServiceSelfColOpenUMLFe2V1',
            'serviceTiresOpenUMLFe2V1' => '\\Dpd\\App\\StructType\\ServiceTiresOpenUMLFe2V1',
            'serviceTiresExportOpenUMLFe2V1' => '\\Dpd\\App\\StructType\\ServiceTiresExportOpenUMLFe2V1',
            'authDataV1' => '\\Dpd\\App\\StructType\\AuthDataV1',
            'importPackagesV1Response' => '\\Dpd\\App\\StructType\\ImportPackagesV1Response',
            'packagesImportResponseV1' => '\\Dpd\\App\\StructType\\PackagesImportResponseV1',
            'sessionPIMV1' => '\\Dpd\\App\\StructType\\SessionPIMV1',
            'packagePIMV1' => '\\Dpd\\App\\StructType\\PackagePIMV1',
            'parcelPIMV1' => '\\Dpd\\App\\StructType\\ParcelPIMV1',
            'statusInfoPIMV1' => '\\Dpd\\App\\StructType\\StatusInfoPIMV1',
            'errorDetailsPIMV1' => '\\Dpd\\App\\StructType\\ErrorDetailsPIMV1',
            'DPDAppServiceException' => '\\Dpd\\App\\StructType\\DPDAppServiceException',
            'importCROUTPackageStatusV1' => '\\Dpd\\App\\StructType\\ImportCROUTPackageStatusV1',
            'importCROUTPackageStatusV1Response' => '\\Dpd\\App\\StructType\\ImportCROUTPackageStatusV1Response',
            'packageStatusImportResponseV1' => '\\Dpd\\App\\StructType\\PackageStatusImportResponseV1',
        );
    }
}
