<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.legaonline.se/financialAPI.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.legaonline.se/financialAPI.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddPayment operation/method
 */
if ($add->AddPayment(new \StructType\AddPayment()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddPaymentXml operation/method
 */
if ($add->AddPaymentXml(new \StructType\AddPaymentXml()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetAccountSetting operation/method
 */
if ($get->GetAccountSetting(new \StructType\GetAccountSetting()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAuthToken operation/method
 */
if ($get->GetAuthToken(new \StructType\GetAuthToken()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomer operation/method
 */
if ($get->GetCustomer(new \StructType\GetCustomer()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerGroup operation/method
 */
if ($get->GetCustomerGroup(new \StructType\GetCustomerGroup()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerGroupXml operation/method
 */
if ($get->GetCustomerGroupXml(new \StructType\GetCustomerGroupXml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerTransactionData operation/method
 */
if ($get->GetCustomerTransactionData(new \StructType\GetCustomerTransactionData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerV2 operation/method
 */
if ($get->GetCustomerV2(new \StructType\GetCustomerV2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerV2Xml operation/method
 */
if ($get->GetCustomerV2Xml(new \StructType\GetCustomerV2Xml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerV3 operation/method
 */
if ($get->GetCustomerV3(new \StructType\GetCustomerV3()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerV3Xml operation/method
 */
if ($get->GetCustomerV3Xml(new \StructType\GetCustomerV3Xml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerV4 operation/method
 */
if ($get->GetCustomerV4(new \StructType\GetCustomerV4()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerV4Xml operation/method
 */
if ($get->GetCustomerV4Xml(new \StructType\GetCustomerV4Xml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerV5 operation/method
 */
if ($get->GetCustomerV5(new \StructType\GetCustomerV5()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerV5Xml operation/method
 */
if ($get->GetCustomerV5Xml(new \StructType\GetCustomerV5Xml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerXml operation/method
 */
if ($get->GetCustomerXml(new \StructType\GetCustomerXml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoice operation/method
 */
if ($get->GetInvoice(new \StructType\GetInvoice()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceCustomerContact operation/method
 */
if ($get->GetInvoiceCustomerContact(new \StructType\GetInvoiceCustomerContact()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceCustomerContactXml operation/method
 */
if ($get->GetInvoiceCustomerContactXml(new \StructType\GetInvoiceCustomerContactXml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceTransactionData operation/method
 */
if ($get->GetInvoiceTransactionData(new \StructType\GetInvoiceTransactionData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceV2 operation/method
 */
if ($get->GetInvoiceV2(new \StructType\GetInvoiceV2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceV2Xml operation/method
 */
if ($get->GetInvoiceV2Xml(new \StructType\GetInvoiceV2Xml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceV3 operation/method
 */
if ($get->GetInvoiceV3(new \StructType\GetInvoiceV3()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceV3Xml operation/method
 */
if ($get->GetInvoiceV3Xml(new \StructType\GetInvoiceV3Xml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceV4 operation/method
 */
if ($get->GetInvoiceV4(new \StructType\GetInvoiceV4()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceV4Xml operation/method
 */
if ($get->GetInvoiceV4Xml(new \StructType\GetInvoiceV4Xml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceV5 operation/method
 */
if ($get->GetInvoiceV5(new \StructType\GetInvoiceV5()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceV5Xml operation/method
 */
if ($get->GetInvoiceV5Xml(new \StructType\GetInvoiceV5Xml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceV6 operation/method
 */
if ($get->GetInvoiceV6(new \StructType\GetInvoiceV6()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceV6Xml operation/method
 */
if ($get->GetInvoiceV6Xml(new \StructType\GetInvoiceV6Xml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceV7 operation/method
 */
if ($get->GetInvoiceV7(new \StructType\GetInvoiceV7()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetInvoiceXml operation/method
 */
if ($get->GetInvoiceXml(new \StructType\GetInvoiceXml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUnpaidInvoice operation/method
 */
if ($get->GetUnpaidInvoice(new \StructType\GetUnpaidInvoice()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
/**
 * Sample call for SetEmptyAccountSetting operation/method
 */
if ($set->SetEmptyAccountSetting(new \StructType\SetEmptyAccountSetting()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetBalance operation/method
 */
if ($set->SetBalance(new \StructType\SetBalance()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetBalanceXml operation/method
 */
if ($set->SetBalanceXml(new \StructType\SetBalanceXml()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCustomer operation/method
 */
if ($set->SetCustomer(new \StructType\SetCustomer()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCustomerV2 operation/method
 */
if ($set->SetCustomerV2(new \StructType\SetCustomerV2()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCustomerV3 operation/method
 */
if ($set->SetCustomerV3(new \StructType\SetCustomerV3()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCustomerV4 operation/method
 */
if ($set->SetCustomerV4(new \StructType\SetCustomerV4()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCustomerV5 operation/method
 */
if ($set->SetCustomerV5(new \StructType\SetCustomerV5()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCustomerXml operation/method
 */
if ($set->SetCustomerXml(new \StructType\SetCustomerXml()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetExported operation/method
 */
if ($set->SetExported(new \StructType\SetExported()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetInvoiceNumber operation/method
 */
if ($set->SetInvoiceNumber(new \StructType\SetInvoiceNumber()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Invalidate ServiceType
 */
$invalidate = new \ServiceType\Invalidate($options);
/**
 * Sample call for InvalidateInvoice operation/method
 */
if ($invalidate->InvalidateInvoice(new \StructType\InvalidateInvoice()) !== false) {
    print_r($invalidate->getResult());
} else {
    print_r($invalidate->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \ServiceType\Validate($options);
/**
 * Sample call for ValidateAuthToken operation/method
 */
if ($validate->ValidateAuthToken(new \StructType\ValidateAuthToken()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
