<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateAuthToken StructType
 * @subpackage Structs
 */
class ValidateAuthToken extends AbstractStructBase
{
    /**
     * The authToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authToken;
    /**
     * Constructor method for ValidateAuthToken
     * @uses ValidateAuthToken::setAuthToken()
     * @param string $authToken
     */
    public function __construct($authToken = null)
    {
        $this
            ->setAuthToken($authToken);
    }
    /**
     * Get authToken value
     * @return string|null
     */
    public function getAuthToken()
    {
        return $this->authToken;
    }
    /**
     * Set authToken value
     * @param string $authToken
     * @return \StructType\ValidateAuthToken
     */
    public function setAuthToken($authToken = null)
    {
        // validation for constraint: string
        if (!is_null($authToken) && !is_string($authToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authToken, true), gettype($authToken)), __LINE__);
        }
        $this->authToken = $authToken;
        return $this;
    }
}
