<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetInvoiceNumber StructType
 * @subpackage Structs
 */
class SetInvoiceNumber extends AbstractStructBase
{
    /**
     * The invoiceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $invoiceID;
    /**
     * The authToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authToken;
    /**
     * The invoiceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $invoiceNumber;
    /**
     * Constructor method for SetInvoiceNumber
     * @uses SetInvoiceNumber::setInvoiceID()
     * @uses SetInvoiceNumber::setAuthToken()
     * @uses SetInvoiceNumber::setInvoiceNumber()
     * @param int $invoiceID
     * @param string $authToken
     * @param string $invoiceNumber
     */
    public function __construct($invoiceID = null, $authToken = null, $invoiceNumber = null)
    {
        $this
            ->setInvoiceID($invoiceID)
            ->setAuthToken($authToken)
            ->setInvoiceNumber($invoiceNumber);
    }
    /**
     * Get invoiceID value
     * @return int
     */
    public function getInvoiceID()
    {
        return $this->invoiceID;
    }
    /**
     * Set invoiceID value
     * @param int $invoiceID
     * @return \StructType\SetInvoiceNumber
     */
    public function setInvoiceID($invoiceID = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceID) && !(is_int($invoiceID) || ctype_digit($invoiceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceID, true), gettype($invoiceID)), __LINE__);
        }
        $this->invoiceID = $invoiceID;
        return $this;
    }
    /**
     * Get authToken value
     * @return string|null
     */
    public function getAuthToken()
    {
        return $this->authToken;
    }
    /**
     * Set authToken value
     * @param string $authToken
     * @return \StructType\SetInvoiceNumber
     */
    public function setAuthToken($authToken = null)
    {
        // validation for constraint: string
        if (!is_null($authToken) && !is_string($authToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authToken, true), gettype($authToken)), __LINE__);
        }
        $this->authToken = $authToken;
        return $this;
    }
    /**
     * Get invoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->invoiceNumber;
    }
    /**
     * Set invoiceNumber value
     * @param string $invoiceNumber
     * @return \StructType\SetInvoiceNumber
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->invoiceNumber = $invoiceNumber;
        return $this;
    }
}
