<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetCustomerV4 StructType
 * @subpackage Structs
 */
class SetCustomerV4 extends AbstractStructBase
{
    /**
     * The authToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authToken;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCustomerV4
     */
    public $customer;
    /**
     * Constructor method for SetCustomerV4
     * @uses SetCustomerV4::setAuthToken()
     * @uses SetCustomerV4::setCustomer()
     * @param string $authToken
     * @param \ArrayType\ArrayOfCustomerV4 $customer
     */
    public function __construct($authToken = null, \ArrayType\ArrayOfCustomerV4 $customer = null)
    {
        $this
            ->setAuthToken($authToken)
            ->setCustomer($customer);
    }
    /**
     * Get authToken value
     * @return string|null
     */
    public function getAuthToken()
    {
        return $this->authToken;
    }
    /**
     * Set authToken value
     * @param string $authToken
     * @return \StructType\SetCustomerV4
     */
    public function setAuthToken($authToken = null)
    {
        // validation for constraint: string
        if (!is_null($authToken) && !is_string($authToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authToken, true), gettype($authToken)), __LINE__);
        }
        $this->authToken = $authToken;
        return $this;
    }
    /**
     * Get customer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCustomerV4|null
     */
    public function getCustomer()
    {
        return isset($this->customer) ? $this->customer : null;
    }
    /**
     * Set customer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCustomerV4 $customer
     * @return \StructType\SetCustomerV4
     */
    public function setCustomer(\ArrayType\ArrayOfCustomerV4 $customer = null)
    {
        if (is_null($customer) || (is_array($customer) && empty($customer))) {
            unset($this->customer);
        } else {
            $this->customer = $customer;
        }
        return $this;
    }
}
