<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceRow StructType
 * @subpackage Structs
 */
class InvoiceRow extends AbstractStructBase
{
    /**
     * The InvoiceRowID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceRowID;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalPrice;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Quantity;
    /**
     * The ObjectID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ObjectID;
    /**
     * The DiscountPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DiscountPercent;
    /**
     * The VatPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VatPercent;
    /**
     * The ItemNr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemNr;
    /**
     * The CostCenter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CostCenter;
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Account;
    /**
     * The ProjectNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProjectNumber;
    /**
     * The BusinessNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BusinessNumber;
    /**
     * The RowText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RowText;
    /**
     * Constructor method for InvoiceRow
     * @uses InvoiceRow::setInvoiceRowID()
     * @uses InvoiceRow::setPrice()
     * @uses InvoiceRow::setTotalPrice()
     * @uses InvoiceRow::setQuantity()
     * @uses InvoiceRow::setObjectID()
     * @uses InvoiceRow::setDiscountPercent()
     * @uses InvoiceRow::setVatPercent()
     * @uses InvoiceRow::setItemNr()
     * @uses InvoiceRow::setCostCenter()
     * @uses InvoiceRow::setAccount()
     * @uses InvoiceRow::setProjectNumber()
     * @uses InvoiceRow::setBusinessNumber()
     * @uses InvoiceRow::setRowText()
     * @param int $invoiceRowID
     * @param float $price
     * @param float $totalPrice
     * @param int $quantity
     * @param int $objectID
     * @param int $discountPercent
     * @param int $vatPercent
     * @param string $itemNr
     * @param string $costCenter
     * @param string $account
     * @param string $projectNumber
     * @param string $businessNumber
     * @param string $rowText
     */
    public function __construct($invoiceRowID = null, $price = null, $totalPrice = null, $quantity = null, $objectID = null, $discountPercent = null, $vatPercent = null, $itemNr = null, $costCenter = null, $account = null, $projectNumber = null, $businessNumber = null, $rowText = null)
    {
        $this
            ->setInvoiceRowID($invoiceRowID)
            ->setPrice($price)
            ->setTotalPrice($totalPrice)
            ->setQuantity($quantity)
            ->setObjectID($objectID)
            ->setDiscountPercent($discountPercent)
            ->setVatPercent($vatPercent)
            ->setItemNr($itemNr)
            ->setCostCenter($costCenter)
            ->setAccount($account)
            ->setProjectNumber($projectNumber)
            ->setBusinessNumber($businessNumber)
            ->setRowText($rowText);
    }
    /**
     * Get InvoiceRowID value
     * @return int
     */
    public function getInvoiceRowID()
    {
        return $this->InvoiceRowID;
    }
    /**
     * Set InvoiceRowID value
     * @param int $invoiceRowID
     * @return \StructType\InvoiceRow
     */
    public function setInvoiceRowID($invoiceRowID = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceRowID) && !(is_int($invoiceRowID) || ctype_digit($invoiceRowID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceRowID, true), gettype($invoiceRowID)), __LINE__);
        }
        $this->InvoiceRowID = $invoiceRowID;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\InvoiceRow
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return float
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param float $totalPrice
     * @return \StructType\InvoiceRow
     */
    public function setTotalPrice($totalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalPrice) && !(is_float($totalPrice) || is_numeric($totalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPrice, true), gettype($totalPrice)), __LINE__);
        }
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\InvoiceRow
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ObjectID value
     * @return int
     */
    public function getObjectID()
    {
        return $this->ObjectID;
    }
    /**
     * Set ObjectID value
     * @param int $objectID
     * @return \StructType\InvoiceRow
     */
    public function setObjectID($objectID = null)
    {
        // validation for constraint: int
        if (!is_null($objectID) && !(is_int($objectID) || ctype_digit($objectID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objectID, true), gettype($objectID)), __LINE__);
        }
        $this->ObjectID = $objectID;
        return $this;
    }
    /**
     * Get DiscountPercent value
     * @return int
     */
    public function getDiscountPercent()
    {
        return $this->DiscountPercent;
    }
    /**
     * Set DiscountPercent value
     * @param int $discountPercent
     * @return \StructType\InvoiceRow
     */
    public function setDiscountPercent($discountPercent = null)
    {
        // validation for constraint: int
        if (!is_null($discountPercent) && !(is_int($discountPercent) || ctype_digit($discountPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($discountPercent, true), gettype($discountPercent)), __LINE__);
        }
        $this->DiscountPercent = $discountPercent;
        return $this;
    }
    /**
     * Get VatPercent value
     * @return int
     */
    public function getVatPercent()
    {
        return $this->VatPercent;
    }
    /**
     * Set VatPercent value
     * @param int $vatPercent
     * @return \StructType\InvoiceRow
     */
    public function setVatPercent($vatPercent = null)
    {
        // validation for constraint: int
        if (!is_null($vatPercent) && !(is_int($vatPercent) || ctype_digit($vatPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vatPercent, true), gettype($vatPercent)), __LINE__);
        }
        $this->VatPercent = $vatPercent;
        return $this;
    }
    /**
     * Get ItemNr value
     * @return string|null
     */
    public function getItemNr()
    {
        return $this->ItemNr;
    }
    /**
     * Set ItemNr value
     * @param string $itemNr
     * @return \StructType\InvoiceRow
     */
    public function setItemNr($itemNr = null)
    {
        // validation for constraint: string
        if (!is_null($itemNr) && !is_string($itemNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemNr, true), gettype($itemNr)), __LINE__);
        }
        $this->ItemNr = $itemNr;
        return $this;
    }
    /**
     * Get CostCenter value
     * @return string|null
     */
    public function getCostCenter()
    {
        return $this->CostCenter;
    }
    /**
     * Set CostCenter value
     * @param string $costCenter
     * @return \StructType\InvoiceRow
     */
    public function setCostCenter($costCenter = null)
    {
        // validation for constraint: string
        if (!is_null($costCenter) && !is_string($costCenter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costCenter, true), gettype($costCenter)), __LINE__);
        }
        $this->CostCenter = $costCenter;
        return $this;
    }
    /**
     * Get Account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param string $account
     * @return \StructType\InvoiceRow
     */
    public function setAccount($account = null)
    {
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account, true), gettype($account)), __LINE__);
        }
        $this->Account = $account;
        return $this;
    }
    /**
     * Get ProjectNumber value
     * @return string|null
     */
    public function getProjectNumber()
    {
        return $this->ProjectNumber;
    }
    /**
     * Set ProjectNumber value
     * @param string $projectNumber
     * @return \StructType\InvoiceRow
     */
    public function setProjectNumber($projectNumber = null)
    {
        // validation for constraint: string
        if (!is_null($projectNumber) && !is_string($projectNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectNumber, true), gettype($projectNumber)), __LINE__);
        }
        $this->ProjectNumber = $projectNumber;
        return $this;
    }
    /**
     * Get BusinessNumber value
     * @return string|null
     */
    public function getBusinessNumber()
    {
        return $this->BusinessNumber;
    }
    /**
     * Set BusinessNumber value
     * @param string $businessNumber
     * @return \StructType\InvoiceRow
     */
    public function setBusinessNumber($businessNumber = null)
    {
        // validation for constraint: string
        if (!is_null($businessNumber) && !is_string($businessNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessNumber, true), gettype($businessNumber)), __LINE__);
        }
        $this->BusinessNumber = $businessNumber;
        return $this;
    }
    /**
     * Get RowText value
     * @return string|null
     */
    public function getRowText()
    {
        return $this->RowText;
    }
    /**
     * Set RowText value
     * @param string $rowText
     * @return \StructType\InvoiceRow
     */
    public function setRowText($rowText = null)
    {
        // validation for constraint: string
        if (!is_null($rowText) && !is_string($rowText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowText, true), gettype($rowText)), __LINE__);
        }
        $this->RowText = $rowText;
        return $this;
    }
}
