<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInvoiceTransactionData StructType
 * @subpackage Structs
 */
class GetInvoiceTransactionData extends AbstractStructBase
{
    /**
     * The authToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authToken;
    /**
     * The invoiceIDs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $invoiceIDs;
    /**
     * Constructor method for GetInvoiceTransactionData
     * @uses GetInvoiceTransactionData::setAuthToken()
     * @uses GetInvoiceTransactionData::setInvoiceIDs()
     * @param string $authToken
     * @param \ArrayType\ArrayOfInt $invoiceIDs
     */
    public function __construct($authToken = null, \ArrayType\ArrayOfInt $invoiceIDs = null)
    {
        $this
            ->setAuthToken($authToken)
            ->setInvoiceIDs($invoiceIDs);
    }
    /**
     * Get authToken value
     * @return string|null
     */
    public function getAuthToken()
    {
        return $this->authToken;
    }
    /**
     * Set authToken value
     * @param string $authToken
     * @return \StructType\GetInvoiceTransactionData
     */
    public function setAuthToken($authToken = null)
    {
        // validation for constraint: string
        if (!is_null($authToken) && !is_string($authToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authToken, true), gettype($authToken)), __LINE__);
        }
        $this->authToken = $authToken;
        return $this;
    }
    /**
     * Get invoiceIDs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getInvoiceIDs()
    {
        return isset($this->invoiceIDs) ? $this->invoiceIDs : null;
    }
    /**
     * Set invoiceIDs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfInt $invoiceIDs
     * @return \StructType\GetInvoiceTransactionData
     */
    public function setInvoiceIDs(\ArrayType\ArrayOfInt $invoiceIDs = null)
    {
        if (is_null($invoiceIDs) || (is_array($invoiceIDs) && empty($invoiceIDs))) {
            unset($this->invoiceIDs);
        } else {
            $this->invoiceIDs = $invoiceIDs;
        }
        return $this;
    }
}
