<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerTransactionData StructType
 * @subpackage Structs
 */
class GetCustomerTransactionData extends AbstractStructBase
{
    /**
     * The authToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authToken;
    /**
     * The customerIDs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $customerIDs;
    /**
     * Constructor method for GetCustomerTransactionData
     * @uses GetCustomerTransactionData::setAuthToken()
     * @uses GetCustomerTransactionData::setCustomerIDs()
     * @param string $authToken
     * @param \ArrayType\ArrayOfInt $customerIDs
     */
    public function __construct($authToken = null, \ArrayType\ArrayOfInt $customerIDs = null)
    {
        $this
            ->setAuthToken($authToken)
            ->setCustomerIDs($customerIDs);
    }
    /**
     * Get authToken value
     * @return string|null
     */
    public function getAuthToken()
    {
        return $this->authToken;
    }
    /**
     * Set authToken value
     * @param string $authToken
     * @return \StructType\GetCustomerTransactionData
     */
    public function setAuthToken($authToken = null)
    {
        // validation for constraint: string
        if (!is_null($authToken) && !is_string($authToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authToken, true), gettype($authToken)), __LINE__);
        }
        $this->authToken = $authToken;
        return $this;
    }
    /**
     * Get customerIDs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getCustomerIDs()
    {
        return isset($this->customerIDs) ? $this->customerIDs : null;
    }
    /**
     * Set customerIDs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfInt $customerIDs
     * @return \StructType\GetCustomerTransactionData
     */
    public function setCustomerIDs(\ArrayType\ArrayOfInt $customerIDs = null)
    {
        if (is_null($customerIDs) || (is_array($customerIDs) && empty($customerIDs))) {
            unset($this->customerIDs);
        } else {
            $this->customerIDs = $customerIDs;
        }
        return $this;
    }
}
