<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAuthToken StructType
 * @subpackage Structs
 */
class GetAuthToken extends AbstractStructBase
{
    /**
     * The userID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $userID;
    /**
     * The hash
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hash;
    /**
     * Constructor method for GetAuthToken
     * @uses GetAuthToken::setUserID()
     * @uses GetAuthToken::setHash()
     * @param int $userID
     * @param string $hash
     */
    public function __construct($userID = null, $hash = null)
    {
        $this
            ->setUserID($userID)
            ->setHash($hash);
    }
    /**
     * Get userID value
     * @return int
     */
    public function getUserID()
    {
        return $this->userID;
    }
    /**
     * Set userID value
     * @param int $userID
     * @return \StructType\GetAuthToken
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !(is_int($userID) || ctype_digit($userID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->userID = $userID;
        return $this;
    }
    /**
     * Get hash value
     * @return string|null
     */
    public function getHash()
    {
        return $this->hash;
    }
    /**
     * Set hash value
     * @param string $hash
     * @return \StructType\GetAuthToken
     */
    public function setHash($hash = null)
    {
        // validation for constraint: string
        if (!is_null($hash) && !is_string($hash)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hash, true), gettype($hash)), __LINE__);
        }
        $this->hash = $hash;
        return $this;
    }
}
