<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountSetting StructType
 * @subpackage Structs
 */
class GetAccountSetting extends AbstractStructBase
{
    /**
     * The setting
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $setting;
    /**
     * The authToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authToken;
    /**
     * Constructor method for GetAccountSetting
     * @uses GetAccountSetting::setSetting()
     * @uses GetAccountSetting::setAuthToken()
     * @param string $setting
     * @param string $authToken
     */
    public function __construct($setting = null, $authToken = null)
    {
        $this
            ->setSetting($setting)
            ->setAuthToken($authToken);
    }
    /**
     * Get setting value
     * @return string
     */
    public function getSetting()
    {
        return $this->setting;
    }
    /**
     * Set setting value
     * @uses \EnumType\AccountSetting::valueIsValid()
     * @uses \EnumType\AccountSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $setting
     * @return \StructType\GetAccountSetting
     */
    public function setSetting($setting = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountSetting::valueIsValid($setting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountSetting', is_array($setting) ? implode(', ', $setting) : var_export($setting, true), implode(', ', \EnumType\AccountSetting::getValidValues())), __LINE__);
        }
        $this->setting = $setting;
        return $this;
    }
    /**
     * Get authToken value
     * @return string|null
     */
    public function getAuthToken()
    {
        return $this->authToken;
    }
    /**
     * Set authToken value
     * @param string $authToken
     * @return \StructType\GetAccountSetting
     */
    public function setAuthToken($authToken = null)
    {
        // validation for constraint: string
        if (!is_null($authToken) && !is_string($authToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authToken, true), gettype($authToken)), __LINE__);
        }
        $this->authToken = $authToken;
        return $this;
    }
}
