<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttributeAlternative StructType
 * @subpackage Structs
 */
class AttributeAlternative extends AbstractStructBase
{
    /**
     * The AttributeAlternativeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AttributeAlternativeID;
    /**
     * The AttributeAlternativeDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AttributeAlternativeDescription;
    /**
     * Constructor method for AttributeAlternative
     * @uses AttributeAlternative::setAttributeAlternativeID()
     * @uses AttributeAlternative::setAttributeAlternativeDescription()
     * @param int $attributeAlternativeID
     * @param string $attributeAlternativeDescription
     */
    public function __construct($attributeAlternativeID = null, $attributeAlternativeDescription = null)
    {
        $this
            ->setAttributeAlternativeID($attributeAlternativeID)
            ->setAttributeAlternativeDescription($attributeAlternativeDescription);
    }
    /**
     * Get AttributeAlternativeID value
     * @return int
     */
    public function getAttributeAlternativeID()
    {
        return $this->AttributeAlternativeID;
    }
    /**
     * Set AttributeAlternativeID value
     * @param int $attributeAlternativeID
     * @return \StructType\AttributeAlternative
     */
    public function setAttributeAlternativeID($attributeAlternativeID = null)
    {
        // validation for constraint: int
        if (!is_null($attributeAlternativeID) && !(is_int($attributeAlternativeID) || ctype_digit($attributeAlternativeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($attributeAlternativeID, true), gettype($attributeAlternativeID)), __LINE__);
        }
        $this->AttributeAlternativeID = $attributeAlternativeID;
        return $this;
    }
    /**
     * Get AttributeAlternativeDescription value
     * @return string|null
     */
    public function getAttributeAlternativeDescription()
    {
        return $this->AttributeAlternativeDescription;
    }
    /**
     * Set AttributeAlternativeDescription value
     * @param string $attributeAlternativeDescription
     * @return \StructType\AttributeAlternative
     */
    public function setAttributeAlternativeDescription($attributeAlternativeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($attributeAlternativeDescription) && !is_string($attributeAlternativeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attributeAlternativeDescription, true), gettype($attributeAlternativeDescription)), __LINE__);
        }
        $this->AttributeAlternativeDescription = $attributeAlternativeDescription;
        return $this;
    }
}
