<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetEmptyAccountSetting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetEmptyAccountSetting $parameters
     * @return \StructType\SetEmptyAccountSettingResponse|bool
     */
    public function SetEmptyAccountSetting(\StructType\SetEmptyAccountSetting $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetEmptyAccountSetting($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetBalance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetBalance $parameters
     * @return \StructType\SetBalanceResponse|bool
     */
    public function SetBalance(\StructType\SetBalance $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetBalance($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetBalanceXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetBalanceXml $parameters
     * @return \StructType\SetBalanceXmlResponse|bool
     */
    public function SetBalanceXml(\StructType\SetBalanceXml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetBalanceXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCustomer $parameters
     * @return \StructType\SetCustomerResponse|bool
     */
    public function SetCustomer(\StructType\SetCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCustomerV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCustomerV2 $parameters
     * @return \StructType\SetCustomerV2Response|bool
     */
    public function SetCustomerV2(\StructType\SetCustomerV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetCustomerV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCustomerV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCustomerV3 $parameters
     * @return \StructType\SetCustomerV3Response|bool
     */
    public function SetCustomerV3(\StructType\SetCustomerV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetCustomerV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCustomerV4
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCustomerV4 $parameters
     * @return \StructType\SetCustomerV4Response|bool
     */
    public function SetCustomerV4(\StructType\SetCustomerV4 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetCustomerV4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCustomerV5
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCustomerV5 $parameters
     * @return \StructType\SetCustomerV5Response|bool
     */
    public function SetCustomerV5(\StructType\SetCustomerV5 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetCustomerV5($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCustomerXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCustomerXml $parameters
     * @return \StructType\SetCustomerXmlResponse|bool
     */
    public function SetCustomerXml(\StructType\SetCustomerXml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetCustomerXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetExported
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetExported $parameters
     * @return \StructType\SetExportedResponse|bool
     */
    public function SetExported(\StructType\SetExported $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetExported($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetInvoiceNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetInvoiceNumber $parameters
     * @return \StructType\SetInvoiceNumberResponse|bool
     */
    public function SetInvoiceNumber(\StructType\SetInvoiceNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetInvoiceNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SetBalanceResponse|\StructType\SetBalanceXmlResponse|\StructType\SetCustomerResponse|\StructType\SetCustomerV2Response|\StructType\SetCustomerV3Response|\StructType\SetCustomerV4Response|\StructType\SetCustomerV5Response|\StructType\SetCustomerXmlResponse|\StructType\SetEmptyAccountSettingResponse|\StructType\SetExportedResponse|\StructType\SetInvoiceNumberResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
